/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftlong;

import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class HardSoftLongScoreInliner
extends ScoreInliner<HardSoftLongScore> {
    private long hardScore;
    private long softScore;

    protected HardSoftLongScoreInliner(Map<Constraint, HardSoftLongScore> constraintToWeightMap, boolean constraintMatchEnabled) {
        super(constraintToWeightMap, constraintMatchEnabled, HardSoftLongScore.ZERO);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        HardSoftLongScore constraintWeight = (HardSoftLongScore)this.getConstraintWeight(constraint);
        long hardConstraintWeight = constraintWeight.getHardScore();
        long softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight == 0L) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                long hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                UndoScoreImpacter undoScoreImpact = () -> this.hardScore -= hardImpact;
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftLongScore.ofHard(hardImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        if (hardConstraintWeight == 0L) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                long softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                UndoScoreImpacter undoScoreImpact = () -> this.softScore -= softImpact;
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftLongScore.ofSoft(softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            long hardImpact = hardConstraintWeight * matchWeight;
            long softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.softScore += softImpact;
            UndoScoreImpacter undoScoreImpact = () -> {
                this.hardScore -= hardImpact;
                this.softScore -= softImpact;
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftLongScore.of(hardImpact, softImpact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftLongScore.class.getSimpleName() + " inliner";
    }
}

