/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBridgeBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;

public class BavetGroupBridgeBiNode<A, B, NewA, ResultContainer_, NewB>
extends BavetAbstractBiNode<A, B> {
    private final BiFunction<A, B, NewA> groupKeyMapping;
    private final BiConstraintCollector<A, B, ResultContainer_, NewB> collector;
    private BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode;
    private final Map<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>> tupleMap;

    public BavetGroupBridgeBiNode(BavetConstraintSession session, int nodeIndex, BavetAbstractBiNode<A, B> parentNode, BiFunction<A, B, NewA> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer_, NewB> collector) {
        super(session, nodeIndex);
        this.groupKeyMapping = groupKeyMapping;
        this.collector = collector;
        this.tupleMap = new HashMap<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>>();
    }

    public BavetGroupBridgeBiTuple<A, B, NewA, ResultContainer_, NewB> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetGroupBridgeBiTuple(this, parentTuple);
    }

    public void setGroupNode(BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode) {
        this.groupNode = groupNode;
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        if (this.groupNode == null) {
            throw new IllegalStateException("Impossible state: GroupBridgeNode (" + this + ") has no child GroupNode (" + this.groupNode + ").");
        }
        BavetGroupBridgeBiTuple tuple = (BavetGroupBridgeBiTuple)uncastTuple;
        if (tuple.getChildTuple() != null) {
            BavetGroupBiTuple childTuple = tuple.getChildTuple();
            Object oldGroupKey = childTuple.getGroupKey();
            int parentCount = childTuple.decreaseParentCount();
            tuple.getUndoAccumulator().run();
            childTuple.clearResult();
            tuple.setChildTuple(null);
            tuple.setUndoAccumulator(null);
            if (parentCount == 0) {
                this.tupleMap.remove(oldGroupKey);
                this.session.transitionTuple(childTuple, BavetTupleState.DYING);
            } else {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
        if (tuple.isActive()) {
            Object a = tuple.getFactA();
            Object b = tuple.getFactB();
            NewA groupKey = this.groupKeyMapping.apply(a, b);
            BavetGroupBiTuple childTuple = this.tupleMap.computeIfAbsent(groupKey, k -> this.groupNode.createTuple(groupKey, this.collector.supplier().get()));
            int parentCount = childTuple.increaseParentCount();
            Runnable undoAccumulator = this.collector.accumulator().apply(childTuple.getResultContainer(), a, b);
            tuple.setUndoAccumulator(undoAccumulator);
            childTuple.clearResult();
            tuple.setChildTuple(childTuple);
            if (parentCount == 1) {
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            } else if (childTuple.getState() != BavetTupleState.CREATING) {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
    }

    public String toString() {
        return "GroupBridge()";
    }
}

