/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.PentaFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractAccumulator;

final class QuadAccumulator<A, B, C, D, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final String varB;
    private final String varC;
    private final String varD;
    private final PentaFunction<ResultContainer_, A, B, C, D, Runnable> accumulator;
    private Declaration declarationA;
    private Declaration declarationB;
    private Declaration declarationC;
    private Declaration declarationD;
    private int offsetToA;
    private int offsetToB;
    private int offsetToC;
    private int offsetToD;

    public QuadAccumulator(Variable<A> varA, Variable<B> varB, Variable<C> varC, Variable<D> varD, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.accumulator = Objects.requireNonNull(collector.accumulator());
        this.varA = varA.getName();
        this.varB = varB.getName();
        this.varC = varC.getName();
        this.varD = varD.getName();
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        if (this.declarationA == null) {
            this.init(leftTuple, innerDeclarations);
        }
        Object a = QuadAccumulator.extractValue(this.declarationA, this.offsetToA, leftTuple);
        Object b = QuadAccumulator.extractValue(this.declarationB, this.offsetToB, leftTuple);
        Object c = QuadAccumulator.extractValue(this.declarationC, this.offsetToC, leftTuple);
        Object d = QuadAccumulator.extractValue(this.declarationD, this.offsetToD, leftTuple);
        return this.accumulator.apply(context, a, b, c, d);
    }

    private void init(Tuple leftTuple, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (declaration.getBindingName().equals(this.varA)) {
                this.declarationA = declaration;
                continue;
            }
            if (declaration.getBindingName().equals(this.varB)) {
                this.declarationB = declaration;
                continue;
            }
            if (declaration.getBindingName().equals(this.varC)) {
                this.declarationC = declaration;
                continue;
            }
            if (!declaration.getBindingName().equals(this.varD)) continue;
            this.declarationD = declaration;
        }
        this.offsetToA = QuadAccumulator.findTupleOffset(this.declarationA, leftTuple);
        this.offsetToB = QuadAccumulator.findTupleOffset(this.declarationB, leftTuple);
        this.offsetToC = QuadAccumulator.findTupleOffset(this.declarationC, leftTuple);
        this.offsetToD = QuadAccumulator.findTupleOffset(this.declarationD, leftTuple);
    }
}

