/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorType;
import org.optaplanner.core.config.localsearch.decider.acceptor.LocalSearchAcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.stepcountinghillclimbing.StepCountingHillClimbingType;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.CompositeAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.hillclimbing.HillClimbingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.lateacceptance.LateAcceptanceAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.stepcountinghillclimbing.StepCountingHillClimbingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.EntityTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.MoveTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.ValueTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.EntityRatioTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.FixedTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.ValueRatioTabuSizeStrategy;

public class AcceptorFactory<Solution_> {
    private static final double DEFAULT_WATER_LEVEL_INCREMENT_RATIO = 5.0E-8;
    private final LocalSearchAcceptorConfig acceptorConfig;

    public static <Solution_> AcceptorFactory<Solution_> create(LocalSearchAcceptorConfig acceptorConfig) {
        return new AcceptorFactory<Solution_>(acceptorConfig);
    }

    public AcceptorFactory(LocalSearchAcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public Acceptor<Solution_> buildAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        List acceptorList = Stream.of(this.buildHillClimbingAcceptor(), this.buildStepCountingHillClimbingAcceptor(), this.buildEntityTabuAcceptor(configPolicy), this.buildValueTabuAcceptor(configPolicy), this.buildMoveTabuAcceptor(configPolicy), this.buildUndoMoveTabuAcceptor(configPolicy), this.buildSimulatedAnnealingAcceptor(configPolicy), this.buildLateAcceptanceAcceptor(), this.buildGreatDelugeAcceptor(configPolicy)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (acceptorList.size() == 1) {
            return (Acceptor)acceptorList.get(0);
        }
        if (acceptorList.size() > 1) {
            return new CompositeAcceptor(acceptorList);
        }
        throw new IllegalArgumentException("The acceptor does not specify any acceptorType (" + this.acceptorConfig.getAcceptorTypeList() + ") or other acceptor property.\nFor a good starting values, see the docs section \"Which optimization algorithms should I use?\".");
    }

    private Optional<HillClimbingAcceptor<Solution_>> buildHillClimbingAcceptor() {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.HILL_CLIMBING)) {
            HillClimbingAcceptor acceptor = new HillClimbingAcceptor();
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<StepCountingHillClimbingAcceptor<Solution_>> buildStepCountingHillClimbingAcceptor() {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.STEP_COUNTING_HILL_CLIMBING) || this.acceptorConfig.getStepCountingHillClimbingSize() != null) {
            int stepCountingHillClimbingSize_ = (Integer)ObjectUtils.defaultIfNull((Object)this.acceptorConfig.getStepCountingHillClimbingSize(), (Object)400);
            StepCountingHillClimbingType stepCountingHillClimbingType_ = (StepCountingHillClimbingType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.acceptorConfig.getStepCountingHillClimbingType()), (Object)((Object)StepCountingHillClimbingType.STEP)));
            StepCountingHillClimbingAcceptor acceptor = new StepCountingHillClimbingAcceptor(stepCountingHillClimbingSize_, stepCountingHillClimbingType_);
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<EntityTabuAcceptor<Solution_>> buildEntityTabuAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.ENTITY_TABU) || this.acceptorConfig.getEntityTabuSize() != null || this.acceptorConfig.getEntityTabuRatio() != null || this.acceptorConfig.getFadingEntityTabuSize() != null || this.acceptorConfig.getFadingEntityTabuRatio() != null) {
            EntityTabuAcceptor acceptor = new EntityTabuAcceptor(configPolicy.getLogIndentation());
            if (this.acceptorConfig.getEntityTabuSize() != null) {
                if (this.acceptorConfig.getEntityTabuRatio() != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both acceptorConfig.getEntityTabuSize() (" + this.acceptorConfig.getEntityTabuSize() + ") and acceptorConfig.getEntityTabuRatio() (" + this.acceptorConfig.getEntityTabuRatio() + ").");
                }
                acceptor.setTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getEntityTabuSize()));
            } else if (this.acceptorConfig.getEntityTabuRatio() != null) {
                acceptor.setTabuSizeStrategy(new EntityRatioTabuSizeStrategy(this.acceptorConfig.getEntityTabuRatio()));
            } else if (this.acceptorConfig.getFadingEntityTabuSize() == null && this.acceptorConfig.getFadingEntityTabuRatio() == null) {
                acceptor.setTabuSizeStrategy(new EntityRatioTabuSizeStrategy(0.1));
            }
            if (this.acceptorConfig.getFadingEntityTabuSize() != null) {
                if (this.acceptorConfig.getFadingEntityTabuRatio() != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both acceptorConfig.getFadingEntityTabuSize() (" + this.acceptorConfig.getFadingEntityTabuSize() + ") and acceptorConfig.getFadingEntityTabuRatio() (" + this.acceptorConfig.getFadingEntityTabuRatio() + ").");
                }
                acceptor.setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getFadingEntityTabuSize()));
            } else if (this.acceptorConfig.getFadingEntityTabuRatio() != null) {
                acceptor.setFadingTabuSizeStrategy(new EntityRatioTabuSizeStrategy(this.acceptorConfig.getFadingEntityTabuRatio()));
            }
            if (configPolicy.getEnvironmentMode().isNonIntrusiveFullAsserted()) {
                acceptor.setAssertTabuHashCodeCorrectness(true);
            }
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<ValueTabuAcceptor<Solution_>> buildValueTabuAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.VALUE_TABU) || this.acceptorConfig.getValueTabuSize() != null || this.acceptorConfig.getValueTabuRatio() != null || this.acceptorConfig.getFadingValueTabuSize() != null || this.acceptorConfig.getFadingValueTabuRatio() != null) {
            ValueTabuAcceptor acceptor = new ValueTabuAcceptor(configPolicy.getLogIndentation());
            if (this.acceptorConfig.getValueTabuSize() != null) {
                if (this.acceptorConfig.getValueTabuRatio() != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both acceptorConfig.getValueTabuSize() (" + this.acceptorConfig.getValueTabuSize() + ") and acceptorConfig.getValueTabuRatio() (" + this.acceptorConfig.getValueTabuRatio() + ").");
                }
                acceptor.setTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getValueTabuSize()));
            } else if (this.acceptorConfig.getValueTabuRatio() != null) {
                acceptor.setTabuSizeStrategy(new ValueRatioTabuSizeStrategy(this.acceptorConfig.getValueTabuRatio()));
            }
            if (this.acceptorConfig.getFadingValueTabuSize() != null) {
                if (this.acceptorConfig.getFadingValueTabuRatio() != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both acceptorConfig.getFadingValueTabuSize() (" + this.acceptorConfig.getFadingValueTabuSize() + ") and acceptorConfig.getFadingValueTabuRatio() (" + this.acceptorConfig.getFadingValueTabuRatio() + ").");
                }
                acceptor.setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getFadingValueTabuSize()));
            } else if (this.acceptorConfig.getFadingValueTabuRatio() != null) {
                acceptor.setFadingTabuSizeStrategy(new ValueRatioTabuSizeStrategy(this.acceptorConfig.getFadingValueTabuRatio()));
            }
            if (this.acceptorConfig.getValueTabuSize() != null) {
                acceptor.setTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getValueTabuSize()));
            }
            if (this.acceptorConfig.getFadingValueTabuSize() != null) {
                acceptor.setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getFadingValueTabuSize()));
            }
            if (configPolicy.getEnvironmentMode().isNonIntrusiveFullAsserted()) {
                acceptor.setAssertTabuHashCodeCorrectness(true);
            }
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<MoveTabuAcceptor<Solution_>> buildMoveTabuAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.MOVE_TABU) || this.acceptorConfig.getMoveTabuSize() != null || this.acceptorConfig.getFadingMoveTabuSize() != null) {
            MoveTabuAcceptor acceptor = new MoveTabuAcceptor(configPolicy.getLogIndentation());
            acceptor.setUseUndoMoveAsTabuMove(false);
            if (this.acceptorConfig.getMoveTabuSize() != null) {
                acceptor.setTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getMoveTabuSize()));
            }
            if (this.acceptorConfig.getFadingMoveTabuSize() != null) {
                acceptor.setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getFadingMoveTabuSize()));
            }
            if (configPolicy.getEnvironmentMode().isNonIntrusiveFullAsserted()) {
                acceptor.setAssertTabuHashCodeCorrectness(true);
            }
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<MoveTabuAcceptor<Solution_>> buildUndoMoveTabuAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.UNDO_MOVE_TABU) || this.acceptorConfig.getUndoMoveTabuSize() != null || this.acceptorConfig.getFadingUndoMoveTabuSize() != null) {
            MoveTabuAcceptor acceptor = new MoveTabuAcceptor(configPolicy.getLogIndentation());
            acceptor.setUseUndoMoveAsTabuMove(true);
            if (this.acceptorConfig.getUndoMoveTabuSize() != null) {
                acceptor.setTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getUndoMoveTabuSize()));
            }
            if (this.acceptorConfig.getFadingUndoMoveTabuSize() != null) {
                acceptor.setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.acceptorConfig.getFadingUndoMoveTabuSize()));
            }
            if (configPolicy.getEnvironmentMode().isNonIntrusiveFullAsserted()) {
                acceptor.setAssertTabuHashCodeCorrectness(true);
            }
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<SimulatedAnnealingAcceptor<Solution_>> buildSimulatedAnnealingAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.SIMULATED_ANNEALING) || this.acceptorConfig.getSimulatedAnnealingStartingTemperature() != null) {
            SimulatedAnnealingAcceptor acceptor = new SimulatedAnnealingAcceptor();
            if (this.acceptorConfig.getSimulatedAnnealingStartingTemperature() == null) {
                throw new IllegalArgumentException("The acceptorType (" + (Object)((Object)AcceptorType.SIMULATED_ANNEALING) + ") currently requires a acceptorConfig.getSimulatedAnnealingStartingTemperature() (" + this.acceptorConfig.getSimulatedAnnealingStartingTemperature() + ").");
            }
            acceptor.setStartingTemperature((Score)configPolicy.getScoreDefinition().parseScore(this.acceptorConfig.getSimulatedAnnealingStartingTemperature()));
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<LateAcceptanceAcceptor<Solution_>> buildLateAcceptanceAcceptor() {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.LATE_ACCEPTANCE) || this.acceptorConfig.getLateAcceptanceSize() != null) {
            LateAcceptanceAcceptor acceptor = new LateAcceptanceAcceptor();
            acceptor.setLateAcceptanceSize((Integer)ObjectUtils.defaultIfNull((Object)this.acceptorConfig.getLateAcceptanceSize(), (Object)400));
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }

    private Optional<GreatDelugeAcceptor<Solution_>> buildGreatDelugeAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (this.acceptorConfig.getAcceptorTypeList() != null && this.acceptorConfig.getAcceptorTypeList().contains((Object)AcceptorType.GREAT_DELUGE) || this.acceptorConfig.getGreatDelugeWaterLevelIncrementScore() != null || this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() != null) {
            GreatDelugeAcceptor acceptor = new GreatDelugeAcceptor();
            if (this.acceptorConfig.getGreatDelugeWaterLevelIncrementScore() != null) {
                if (this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both a acceptorConfig.getGreatDelugeWaterLevelIncrementScore() (" + this.acceptorConfig.getGreatDelugeWaterLevelIncrementScore() + ") and a acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() (" + this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() + ").");
                }
                acceptor.setWaterLevelIncrementScore((Score)configPolicy.getScoreDefinition().parseScore(this.acceptorConfig.getGreatDelugeWaterLevelIncrementScore()));
            } else if (this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() != null) {
                if (this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() <= 0.0) {
                    throw new IllegalArgumentException("The acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() (" + this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio() + ") must be positive because the water level should increase.");
                }
                acceptor.setWaterLevelIncrementRatio(this.acceptorConfig.getGreatDelugeWaterLevelIncrementRatio());
            } else {
                acceptor.setWaterLevelIncrementRatio(5.0E-8);
            }
            return Optional.of(acceptor);
        }
        return Optional.empty();
    }
}

