/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream.uni;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;
import org.optaplanner.core.impl.score.stream.uni.UniConstraintStreamHelper;

public interface UniConstraintStream<A>
extends ConstraintStream {
    public UniConstraintStream<A> filter(Predicate<A> var1);

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream) {
        return this.join(otherStream, (BiJoiner<A, B>)new NoneBiJoiner());
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> var1, BiJoiner<A, B> var2);

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> ... joiners) {
        UniConstraintStreamHelper helper = new UniConstraintStreamHelper(this);
        return (BiConstraintStream)helper.join(otherStream, joiners);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass) {
        return this.join(otherClass, (BiJoiner<A, B>)new NoneBiJoiner());
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.join(this.getConstraintFactory().from(otherClass), joiner);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.join(this.getConstraintFactory().from(otherClass), joiner1, joiner2);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.join(this.getConstraintFactory().from(otherClass), joiner1, joiner2, joiner3);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.join(this.getConstraintFactory().from(otherClass), joiner1, joiner2, joiner3, joiner4);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifExists(Class<B> var1, BiJoiner<A, B> ... var2);

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass) {
        return this.ifExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering(ObjectUtils::notEqual));
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering(ObjectUtils::notEqual);
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifExists(otherClass, allJoiners);
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifNotExists(Class<B> var1, BiJoiner<A, B> ... var2);

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass) {
        return this.ifNotExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering(ObjectUtils::notEqual));
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering(ObjectUtils::notEqual);
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifNotExists(otherClass, allJoiners);
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, UniConstraintCollector<A, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3, Function<A, GroupKeyD_> var4);

    public <ResultA_> UniConstraintStream<ResultA_> map(Function<A, ResultA_> var1);

    public <ResultA_> UniConstraintStream<ResultA_> flattenLast(Function<A, Iterable<ResultA_>> var1);

    public UniConstraintStream<A> distinct();

    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalize(String var1, String var2, Score<?> var3, ToIntFunction<A> var4);

    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeLong(String var1, String var2, Score<?> var3, ToLongFunction<A> var4);

    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeBigDecimal(String var1, String var2, Score<?> var3, Function<A, BigDecimal> var4);

    default public Constraint penalizeConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurable(String var1, String var2, ToIntFunction<A> var3);

    default public Constraint penalizeConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableLong(String var1, String var2, ToLongFunction<A> var3);

    default public Constraint penalizeConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableBigDecimal(String var1, String var2, Function<A, BigDecimal> var3);

    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint reward(String var1, String var2, Score<?> var3, ToIntFunction<A> var4);

    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardLong(String var1, String var2, Score<?> var3, ToLongFunction<A> var4);

    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardBigDecimal(String var1, String var2, Score<?> var3, Function<A, BigDecimal> var4);

    default public Constraint rewardConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurable(String var1, String var2, ToIntFunction<A> var3);

    default public Constraint rewardConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableLong(String var1, String var2, ToLongFunction<A> var3);

    default public Constraint rewardConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableBigDecimal(String var1, String var2, Function<A, BigDecimal> var3);

    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.impact(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impact(String var1, String var2, Score<?> var3, ToIntFunction<A> var4);

    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.impactLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactLong(String var1, String var2, Score<?> var3, ToLongFunction<A> var4);

    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactBigDecimal(String var1, String var2, Score<?> var3, Function<A, BigDecimal> var4);

    default public Constraint impactConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.impactConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurable(String var1, String var2, ToIntFunction<A> var3);

    default public Constraint impactConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.impactConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableLong(String var1, String var2, ToLongFunction<A> var3);

    default public Constraint impactConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableBigDecimal(String var1, String var2, Function<A, BigDecimal> var3);
}

