/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityIndependentFilteringValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class FilteringValueSelector<Solution_>
extends AbstractValueSelector<Solution_> {
    protected final ValueSelector<Solution_> childValueSelector;
    protected final List<SelectionFilter<Solution_, Object>> filterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector<Solution_> scoreDirector = null;

    public static <Solution_> ValueSelector<Solution_> create(ValueSelector<Solution_> valueSelector, List<SelectionFilter<Solution_, Object>> filterList) {
        if (valueSelector instanceof EntityIndependentValueSelector) {
            return new EntityIndependentFilteringValueSelector<Solution_>((EntityIndependentValueSelector)valueSelector, filterList);
        }
        return new FilteringValueSelector<Solution_>(valueSelector, filterList);
    }

    protected FilteringValueSelector(ValueSelector<Solution_> childValueSelector, List<SelectionFilter<Solution_, Object>> filterList) {
        this.childValueSelector = childValueSelector;
        this.filterList = filterList;
        this.bailOutEnabled = childValueSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.iterator(entity), this.determineBailOutSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.endingIterator(entity), this.determineBailOutSize(entity));
    }

    protected long determineBailOutSize(Object entity) {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childValueSelector.getSize(entity) * 10L;
    }

    protected boolean accept(ScoreDirector<Solution_> scoreDirector, Object entity) {
        for (SelectionFilter<Solution_, Object> filter : this.filterList) {
            if (filter.accept(scoreDirector, entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childValueSelector + ")";
    }

    protected class JustInTimeFilteringValueIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;
        private final long bailOutSize;

        public JustInTimeFilteringValueIterator(Iterator<Object> childValueIterator, long bailOutSize) {
            this.childValueIterator = childValueIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childValueIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!FilteringValueSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringValueSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringValueSelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringValueSelector.this.accept(FilteringValueSelector.this.scoreDirector, next = this.childValueIterator.next()));
            return next;
        }
    }
}

