/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendable;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class BendableScoreInliner
extends ScoreInliner<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    public BendableScoreInliner(Map<Constraint, BendableScore> constraintToWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintToWeightMap, constraintMatchEnabled, BendableScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        BendableScore constraintWeight = (BendableScore)this.getConstraintWeight(constraint);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if ((long)constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            int levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    int hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    UndoScoreImpacter undoScoreImpact = () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact), (List)justificationsSupplier.get());
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                int softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                UndoScoreImpacter undoScoreImpact = () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            int[] hardImpacts = new int[this.hardScores.length];
            int[] softImpacts = new int[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.of(hardImpacts, softImpacts), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableScore.class.getSimpleName() + " inliner";
    }
}

