/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simple;

import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class SimpleScoreInliner
extends ScoreInliner<SimpleScore> {
    private int score;

    protected SimpleScoreInliner(Map<Constraint, SimpleScore> constraintIdToWeightMap, boolean constraintMatchEnabled) {
        super(constraintIdToWeightMap, constraintMatchEnabled, SimpleScore.ZERO);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        SimpleScore constraintWeight = (SimpleScore)this.getConstraintWeight(constraint);
        int simpleConstraintWeight = constraintWeight.getScore();
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int impact = simpleConstraintWeight * matchWeight;
            this.score += impact;
            UndoScoreImpacter undoScoreImpact = () -> this.score -= impact;
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, SimpleScore.of(impact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public SimpleScore extractScore(int initScore) {
        return SimpleScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleScore.class.getSimpleName() + " inliner";
    }
}

