/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenAbstractValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;

class TestGenInlineListValueProvider
extends TestGenAbstractValueProvider<List<?>> {
    private final Map<Object, TestGenFact> existingInstances;
    private final List<TestGenFact> requiredFacts;

    public TestGenInlineListValueProvider(List<?> value, Map<Object, TestGenFact> existingInstances) {
        super(value);
        this.existingInstances = existingInstances;
        this.requiredFacts = value.stream().map(existingInstances::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<TestGenFact> getRequiredFacts() {
        return this.requiredFacts;
    }

    @Override
    public List<Class<?>> getImports() {
        return Collections.singletonList(Arrays.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25 * ((List)this.value).size() + 17);
        sb.append("Arrays.asList(");
        Iterator it = ((List)this.value).iterator();
        if (it.hasNext()) {
            sb.append(this.existingInstances.get(it.next()));
        }
        while (it.hasNext()) {
            sb.append(", ").append(this.existingInstances.get(it.next()));
        }
        sb.append(")");
        return sb.toString();
    }
}

