/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.drools.core.FactHandle;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.WindowTupleList;
import org.drools.core.rule.EntryPoint;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BitMaskUtil;

public class PropagationContextImpl
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private int type;
    private Rule rule;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    private EntryPoint entryPoint;
    private int originOffset;
    private final LinkedList<WorkingMemoryAction> queue1 = new LinkedList();
    private LinkedList<WorkingMemoryAction> queue2;
    private long modificationMask = Long.MAX_VALUE;
    private long originalMask = Long.MAX_VALUE;
    private Class<?> modifiedClass;
    private WindowTupleList windowTupleList;
    private ObjectType objectType;
    private transient MarshallerReaderContext readerContext;

    public PropagationContextImpl() {
    }

    public PropagationContextImpl(long number, int type, Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this(number, type, rule, leftTuple, factHandle, EntryPoint.DEFAULT, Long.MAX_VALUE, Object.class, null);
        this.originOffset = -1;
    }

    public PropagationContextImpl(long number, int type, Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPoint entryPoint) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, Long.MAX_VALUE, Object.class, null);
    }

    public PropagationContextImpl(long number, int type, Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint, long modificationMask) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, modificationMask, Object.class, null);
    }

    public PropagationContextImpl(long number, int type, Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPoint entryPoint, MarshallerReaderContext readerContext) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, Long.MAX_VALUE, Object.class, readerContext);
    }

    public PropagationContextImpl(long number, int type, Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPoint entryPoint, long modificationMask, Class<?> modifiedClass, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.entryPoint = entryPoint;
        this.originOffset = -1;
        this.modificationMask = modificationMask;
        this.originalMask = modificationMask;
        this.modifiedClass = modifiedClass;
        this.readerContext = readerContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (Rule)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.entryPoint = (EntryPoint)in.readObject();
        this.originOffset = in.readInt();
        this.modificationMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.entryPoint);
        out.writeInt(this.originOffset);
        out.writeLong(this.modificationMask);
    }

    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    public void cleanReaderContext() {
        this.readerContext = null;
    }

    @Override
    public Rule getRuleOrigin() {
        return this.rule;
    }

    public org.kie.api.definition.rule.Rule getRule() {
        return this.rule;
    }

    @Override
    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    @Override
    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public void setFactHandle(FactHandle factHandle) {
        this.factHandle = (InternalFactHandle)factHandle;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void releaseResources() {
        this.leftTuple = null;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public int getOriginOffset() {
        return this.originOffset;
    }

    @Override
    public void setOriginOffset(int originOffset) {
        this.originOffset = originOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.addFirst(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.remove(action);
        }
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue1() {
        return this.queue1;
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue2() {
        if (this.queue2 == null) {
            this.queue2 = new LinkedList();
        }
        return this.queue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateActionQueue(InternalWorkingMemory workingMemory) {
        boolean repeat = true;
        block3: while (repeat) {
            WorkingMemoryAction action;
            LinkedList<WorkingMemoryAction> linkedList = this.queue1;
            synchronized (linkedList) {
                WorkingMemoryAction action2;
                while ((action2 = !this.queue1.isEmpty() ? this.queue1.removeFirst() : null) != null) {
                    action2.execute(workingMemory);
                }
            }
            repeat = false;
            if (this.queue2 == null) continue;
            while ((action = !this.queue2.isEmpty() ? this.queue2.removeFirst() : null) != null) {
                action.execute(workingMemory);
                if (this.queue1.isEmpty()) continue;
                repeat = true;
                continue block3;
            }
        }
    }

    @Override
    public long getModificationMask() {
        return this.modificationMask;
    }

    @Override
    public PropagationContext adaptModificationMaskForObjectType(ObjectType type, InternalWorkingMemory workingMemory) {
        this.modificationMask = this.originalMask;
        if (this.modificationMask == Long.MAX_VALUE || !(type instanceof ClassObjectType)) {
            return this;
        }
        ClassObjectType classObjectType = (ClassObjectType)type;
        Class<?> classType = classObjectType.getClassType();
        if (classType == this.modifiedClass || !classType.isInterface() && !this.modifiedClass.isInterface()) {
            return this;
        }
        Long cachedMask = classObjectType.getTransformedMask(this.modifiedClass, this.originalMask);
        if (cachedMask != null) {
            this.modificationMask = cachedMask;
            return this;
        }
        this.modificationMask = 0L;
        Package rulePkg = workingMemory.getRuleBase().getPackage(this.rule.getPackage());
        List<String> typeClassProps = this.getSettableProperties(workingMemory, classType, rulePkg);
        List<String> modifiedClassProps = this.getSettableProperties(workingMemory, this.modifiedClass, rulePkg);
        for (int i = 0; i < modifiedClassProps.size(); ++i) {
            int posInType;
            if (!BitMaskUtil.isPositionSet(this.originalMask, i) || (posInType = typeClassProps.indexOf(modifiedClassProps.get(i))) < 0) continue;
            this.modificationMask = BitMaskUtil.set(this.modificationMask, posInType);
        }
        classObjectType.storeTransformedMask(this.modifiedClass, this.originalMask, this.modificationMask);
        return this;
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType, Package rulePkg) {
        Package pkg = workingMemory.getRuleBase().getPackage(classType.getPackage().getName());
        return pkg != null ? pkg.getTypeDeclaration(classType).getSettableProperties() : rulePkg.getTypeDeclaration(classType).getSettableProperties();
    }

    @Override
    public WindowTupleList getActiveWindowTupleList() {
        return this.windowTupleList;
    }

    @Override
    public void setActiveWindowTupleList(WindowTupleList list) {
        this.windowTupleList = list;
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "PropagationContextImpl [entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", leftTuple=" + this.leftTuple + ", originOffset=" + this.originOffset + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

