/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase;

import java.util.List;
import java.util.Random;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolverPhaseScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final DefaultSolverScope solverScope;
    protected long startingSystemTimeMillis;
    protected Score startingScore;
    protected int bestSolutionStepIndex;

    public AbstractSolverPhaseScope(DefaultSolverScope solverScope) {
        this.solverScope = solverScope;
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public void setStartingScore(Score startingScore) {
        this.startingScore = startingScore;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope getLastCompletedStepScope();

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.bestSolutionStepIndex = -1;
        this.startingScore = this.solverScope.calculateScore();
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solverScope.getScoreDefinition();
    }

    public long calculateSolverTimeMillisSpend() {
        return this.solverScope.calculateTimeMillisSpend();
    }

    public long calculatePhaseTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public ScoreDirector getScoreDirector() {
        return this.solverScope.getScoreDirector();
    }

    public Solution getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solverScope.getWorkingPlanningEntityList();
    }

    public Score calculateScore() {
        return this.solverScope.calculateScore();
    }

    public void assertExpectedWorkingScore(Score expectedWorkingScore) {
        this.solverScope.assertExpectedWorkingScore(expectedWorkingScore);
    }

    public void assertWorkingScoreFromScratch(Score workingScore) {
        this.solverScope.assertWorkingScoreFromScratch(workingScore);
    }

    public void assertUndoMoveIsUncorrupted(Move move, Move undoMove) {
        Score lastCompletedStepScore;
        Score undoScore = this.calculateScore();
        if (!undoScore.equals(lastCompletedStepScore = this.getLastCompletedStepScope().getScore())) {
            this.getScoreDirector().assertWorkingScoreFromScratch(undoScore);
            throw new IllegalStateException("The moveClass (" + move.getClass() + ")'s move (" + move + ") probably has a corrupted undoMove (" + undoMove + ")." + " Or maybe there are corrupted score rules.\n" + "Check the Move.createUndoMove(...) method of that Move class" + " and enable EnvironmentMode " + (Object)((Object)EnvironmentMode.FULL_ASSERT) + " to fail-faster on corrupted score rules.\n" + "Score corruption: the lastCompletedStepScore (" + lastCompletedStepScore + ") is not the undoScore (" + undoScore + ").");
        }
    }

    public Random getWorkingRandom() {
        return this.solverScope.getWorkingRandom();
    }

    public boolean isBestSolutionInitialized() {
        return this.solverScope.isBestSolutionInitialized();
    }

    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

