/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.builder;

import com.sun.tools.xjc.Options;
import java.util.Properties;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.JaxbConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.utils.ServiceRegistryImpl;

public class KnowledgeBuilderFactory {
    private static volatile KnowledgeBuilderFactoryService factoryService;

    public static KnowledgeBuilder newKnowledgeBuilder() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilder();
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilder(conf);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilder(kbase);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase, KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilder(kbase, conf);
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilderConfiguration();
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(Properties properties, ClassLoader ... classLoaders) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newKnowledgeBuilderConfiguration(properties, classLoaders);
    }

    public static DecisionTableConfiguration newDecisionTableConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newDecisionTableConfiguration();
    }

    public static JaxbConfiguration newJaxbConfiguration(Options xjcOpts, String systemId) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderServiceFactory().newJaxbConfiguration(xjcOpts, systemId);
    }

    private static synchronized void setKnowledgeBuilderFactoryService(KnowledgeBuilderFactoryService serviceFactory) {
        factoryService = serviceFactory;
    }

    private static synchronized KnowledgeBuilderFactoryService getKnowledgeBuilderServiceFactory() {
        if (factoryService == null) {
            KnowledgeBuilderFactory.loadServiceFactory();
        }
        return factoryService;
    }

    private static void loadServiceFactory() {
        KnowledgeBuilderFactory.setKnowledgeBuilderFactoryService(ServiceRegistryImpl.getInstance().get(KnowledgeBuilderFactoryService.class));
    }
}

