/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="CloudBalance")
public class CloudBalance
extends AbstractPersistable
implements Solution<HardSoftScore> {
    private List<CloudComputer> computerList;
    private List<CloudProcess> processList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    private HardSoftScore score;

    public List<CloudComputer> getComputerList() {
        return this.computerList;
    }

    public void setComputerList(List<CloudComputer> computerList) {
        this.computerList = computerList;
    }

    @PlanningEntityCollectionProperty
    public List<CloudProcess> getProcessList() {
        return this.processList;
    }

    public void setProcessList(List<CloudProcess> processList) {
        this.processList = processList;
    }

    @Override
    public HardSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<CloudComputer> facts = new ArrayList<CloudComputer>();
        facts.addAll(this.computerList);
        return facts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CloudBalance)) {
            return false;
        }
        CloudBalance other = (CloudBalance)o;
        if (this.processList.size() != other.processList.size()) {
            return false;
        }
        Iterator<CloudProcess> it = this.processList.iterator();
        Iterator<CloudProcess> otherIt = other.processList.iterator();
        while (it.hasNext()) {
            CloudProcess otherProcess;
            CloudProcess process = it.next();
            if (process.solutionEquals(otherProcess = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CloudProcess process : this.processList) {
            hashCodeBuilder.append(process.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

