/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class LectureDifficultyWeightFactory
implements SelectionSorterWeightFactory<CourseSchedule, Lecture> {
    @Override
    public Comparable createSorterWeight(CourseSchedule schedule, Lecture lecture) {
        Course course = lecture.getCourse();
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getCourse().equals(course)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new LectureDifficultyWeight(lecture, unavailablePeriodPenaltyCount);
    }

    public static class LectureDifficultyWeight
    implements Comparable<LectureDifficultyWeight> {
        private final Lecture lecture;
        private final int unavailablePeriodPenaltyCount;

        public LectureDifficultyWeight(Lecture lecture, int unavailablePeriodPenaltyCount) {
            this.lecture = lecture;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(LectureDifficultyWeight other) {
            Course course = this.lecture.getCourse();
            Course otherCourse = other.lecture.getCourse();
            return new CompareToBuilder().append(course.getCurriculumList().size(), otherCourse.getCurriculumList().size()).append(this.unavailablePeriodPenaltyCount, other.unavailablePeriodPenaltyCount).append(course.getLectureSize(), otherCourse.getLectureSize()).append(course.getStudentSize(), otherCourse.getStudentSize()).append(course.getMinWorkingDaySize(), otherCourse.getMinWorkingDaySize()).append((Object)this.lecture.getId(), (Object)other.lecture.getId()).toComparison();
        }
    }
}

