/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.solver.score;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineReassignmentIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<MachineReassignment> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private MachineReassignment machineReassignment;
    private MrGlobalPenaltyInfo globalPenaltyInfo;
    private Map<MrService, MrServiceScorePart> serviceScorePartMap;
    private Map<Integer, Integer> movedProcessCountToServiceCount;
    private int serviceMoveCost;
    private Map<MrMachine, MrMachineScorePart> machineScorePartMap;
    private long hardScore;
    private long softScore;

    @Override
    public void resetWorkingSolution(MachineReassignment machineReassignment) {
        this.machineReassignment = machineReassignment;
        this.hardScore = 0L;
        this.softScore = 0L;
        this.globalPenaltyInfo = machineReassignment.getGlobalPenaltyInfo();
        List<MrService> serviceList = machineReassignment.getServiceList();
        this.serviceScorePartMap = new HashMap<MrService, MrServiceScorePart>(serviceList.size());
        for (MrService service : serviceList) {
            this.serviceScorePartMap.put(service, new MrServiceScorePart(service));
        }
        this.movedProcessCountToServiceCount = new HashMap<Integer, Integer>(serviceList.size());
        this.movedProcessCountToServiceCount.put(0, serviceList.size());
        this.serviceMoveCost = 0;
        List<MrMachine> machineList = machineReassignment.getMachineList();
        this.machineScorePartMap = new HashMap<MrMachine, MrMachineScorePart>(machineList.size());
        for (MrMachine machine : machineList) {
            this.machineScorePartMap.put(machine, new MrMachineScorePart(machine));
        }
        for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
            MrMachine originalMachine = processAssignment.getOriginalMachine();
            if (originalMachine == null) continue;
            this.machineScorePartMap.get(originalMachine).initOriginalProcessAssignment(processAssignment);
        }
        for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
            this.insert(processAssignment);
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        this.insert((MrProcessAssignment)entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.retract((MrProcessAssignment)entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        this.insert((MrProcessAssignment)entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((MrProcessAssignment)entity);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((MrProcessAssignment)entity);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.retract((MrProcessAssignment)entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    private void insert(MrProcessAssignment processAssignment) {
        MrMachine machine = processAssignment.getMachine();
        if (machine != null) {
            MrServiceScorePart serviceScorePart = this.serviceScorePartMap.get(processAssignment.getService());
            serviceScorePart.addProcessAssignment(processAssignment);
            MrMachineScorePart machineScorePart = this.machineScorePartMap.get(machine);
            machineScorePart.addProcessAssignment(processAssignment);
        }
    }

    private void retract(MrProcessAssignment processAssignment) {
        MrMachine machine = processAssignment.getMachine();
        if (machine != null) {
            MrServiceScorePart serviceScorePart = this.serviceScorePartMap.get(processAssignment.getService());
            serviceScorePart.removeProcessAssignment(processAssignment);
            MrMachineScorePart machineScorePart = this.machineScorePartMap.get(machine);
            machineScorePart.removeProcessAssignment(processAssignment);
        }
    }

    @Override
    public HardSoftLongScore calculateScore() {
        return HardSoftLongScore.valueOf(this.hardScore, this.softScore);
    }

    @Override
    public String buildScoreCorruptionAnalysis(IncrementalScoreCalculator uncorruptedIncrementalScoreCalculator) {
        MachineReassignmentIncrementalScoreCalculator other = (MachineReassignmentIncrementalScoreCalculator)uncorruptedIncrementalScoreCalculator;
        StringBuilder analysis = new StringBuilder();
        if (!((Object)this.serviceScorePartMap.keySet()).equals(other.serviceScorePartMap.keySet())) {
            Collection excess = CollectionUtils.subtract(this.serviceScorePartMap.keySet(), other.serviceScorePartMap.keySet());
            Collection lacking = CollectionUtils.subtract(other.serviceScorePartMap.keySet(), this.serviceScorePartMap.keySet());
            analysis.append("  The serviceScorePartMap has in excess (").append(excess).append(") and is lacking (").append(lacking).append(").\n");
        } else {
            for (Map.Entry<MrService, MrServiceScorePart> entry : this.serviceScorePartMap.entrySet()) {
                Collection lacking;
                Collection excess;
                MrService service = entry.getKey();
                MrServiceScorePart part = entry.getValue();
                MrServiceScorePart otherPart = other.serviceScorePartMap.get(service);
                if (!((Object)part.locationBag).equals(otherPart.locationBag)) {
                    excess = CollectionUtils.subtract(part.locationBag.values(), otherPart.locationBag.values());
                    lacking = CollectionUtils.subtract(otherPart.locationBag.values(), part.locationBag.values());
                    analysis.append("  On service (").append(service).append(") the locationBag has in excess (").append(excess).append(") and is lacking (").append(lacking).append(").\n");
                }
                if (!((Object)part.neighborhoodBag).equals(otherPart.neighborhoodBag)) {
                    excess = CollectionUtils.subtract(part.neighborhoodBag.values(), otherPart.neighborhoodBag.values());
                    lacking = CollectionUtils.subtract(otherPart.neighborhoodBag.values(), part.neighborhoodBag.values());
                    analysis.append("  On service (").append(service).append(") the neighborhoodBag has in excess (").append(excess).append(") and is lacking (").append(lacking).append(").\n");
                }
                if (part.movedProcessCount == otherPart.movedProcessCount) continue;
                analysis.append("  On service (").append(service).append(") the movedProcessCount (").append(part.movedProcessCount).append(") is not correct (").append(otherPart.movedProcessCount).append(").\n");
            }
        }
        return analysis.toString();
    }

    private class MrMachineCapacityScorePart {
        private final MrMachineCapacity machineCapacity;
        private long maximumAvailable;
        private long safetyAvailable;
        private long balanceAvailable;

        private MrMachineCapacityScorePart(MrMachineCapacity machineCapacity) {
            this.machineCapacity = machineCapacity;
            this.maximumAvailable = machineCapacity.getMaximumCapacity();
            this.safetyAvailable = machineCapacity.getSafetyCapacity();
            this.balanceAvailable = machineCapacity.getMaximumCapacity();
        }

        private void initOriginalProcessAssignment(MrProcessAssignment processAssignment) {
            if (this.machineCapacity.isTransientlyConsumed()) {
                long processUsage = processAssignment.getProcess().getProcessRequirement(this.machineCapacity.getResource()).getUsage();
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable -= processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            MrResource resource = this.machineCapacity.getResource();
            long processUsage = processAssignment.getUsage(resource);
            if (!this.machineCapacity.isTransientlyConsumed() || processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable -= processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
            MachineReassignmentIncrementalScoreCalculator.this.softScore -= Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.safetyAvailable -= processUsage;
            MachineReassignmentIncrementalScoreCalculator.this.softScore += Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.balanceAvailable -= processUsage;
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            MrResource resource = this.machineCapacity.getResource();
            long processUsage = processAssignment.getUsage(resource);
            if (!this.machineCapacity.isTransientlyConsumed() || processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable += processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
            MachineReassignmentIncrementalScoreCalculator.this.softScore -= Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.safetyAvailable += processUsage;
            MachineReassignmentIncrementalScoreCalculator.this.softScore += Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.balanceAvailable += processUsage;
        }

        public long getBalanceAvailable() {
            return this.balanceAvailable;
        }
    }

    private class MrMachineScorePart {
        private final MrMachine machine;
        private final List<MrMachineCapacityScorePart> machineCapacityScorePartList;
        private Map<MrService, Integer> serviceBag;

        public MrMachineScorePart(MrMachine machine) {
            this.machine = machine;
            List<MrMachineCapacity> machineCapacityList = machine.getMachineCapacityList();
            this.machineCapacityScorePartList = new ArrayList<MrMachineCapacityScorePart>(machineCapacityList.size());
            for (MrMachineCapacity machineCapacity : machineCapacityList) {
                this.machineCapacityScorePartList.add(new MrMachineCapacityScorePart(machineCapacity));
            }
            this.serviceBag = new HashMap<MrService, Integer>(10);
            this.doBalancePenaltyCosts();
        }

        public void initOriginalProcessAssignment(MrProcessAssignment processAssignment) {
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.initOriginalProcessAssignment(processAssignment);
            }
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            int serviceProcessCount;
            this.undoBalancePenaltyCosts();
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.addProcessAssignment(processAssignment);
            }
            MrService service = processAssignment.getService();
            Integer serviceProcessCountInteger = this.serviceBag.get(service);
            int n = serviceProcessCount = serviceProcessCountInteger == null ? 0 : serviceProcessCountInteger;
            if (serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += serviceProcessCount - 1;
            }
            if (++serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= serviceProcessCount - 1;
            }
            serviceProcessCountInteger = serviceProcessCount == 0 ? null : Integer.valueOf(serviceProcessCount);
            this.serviceBag.put(service, serviceProcessCountInteger);
            this.doBalancePenaltyCosts();
            if (processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= processAssignment.getProcessMoveCost() * MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getProcessMoveCostWeight();
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= processAssignment.getMachineMoveCost() * MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getMachineMoveCostWeight();
            }
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            int serviceProcessCount;
            this.undoBalancePenaltyCosts();
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.removeProcessAssignment(processAssignment);
            }
            MrService service = processAssignment.getService();
            Integer serviceProcessCountInteger = this.serviceBag.get(service);
            int n = serviceProcessCount = serviceProcessCountInteger == null ? 0 : serviceProcessCountInteger;
            if (serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += serviceProcessCount - 1;
            }
            if (--serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= serviceProcessCount - 1;
            }
            serviceProcessCountInteger = serviceProcessCount == 0 ? null : Integer.valueOf(serviceProcessCount);
            this.serviceBag.put(service, serviceProcessCountInteger);
            this.doBalancePenaltyCosts();
            if (processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.softScore += processAssignment.getProcessMoveCost() * MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getProcessMoveCostWeight();
                MachineReassignmentIncrementalScoreCalculator.this.softScore += processAssignment.getMachineMoveCost() * MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getMachineMoveCostWeight();
            }
        }

        private void doBalancePenaltyCosts() {
            for (MrBalancePenalty balancePenalty : MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getBalancePenaltyList()) {
                long minimumTargetAvailable;
                long originAvailable = this.machineCapacityScorePartList.get(balancePenalty.getOriginResource().getIndex()).getBalanceAvailable();
                long targetAvailable = this.machineCapacityScorePartList.get(balancePenalty.getTargetResource().getIndex()).getBalanceAvailable();
                if (originAvailable <= 0L || targetAvailable >= (minimumTargetAvailable = originAvailable * (long)balancePenalty.getMultiplicand())) continue;
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= (minimumTargetAvailable - targetAvailable) * (long)balancePenalty.getWeight();
            }
        }

        private void undoBalancePenaltyCosts() {
            for (MrBalancePenalty balancePenalty : MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getBalancePenaltyList()) {
                long minimumTargetAvailable;
                long originAvailable = this.machineCapacityScorePartList.get(balancePenalty.getOriginResource().getIndex()).getBalanceAvailable();
                long targetAvailable = this.machineCapacityScorePartList.get(balancePenalty.getTargetResource().getIndex()).getBalanceAvailable();
                if (originAvailable <= 0L || targetAvailable >= (minimumTargetAvailable = originAvailable * (long)balancePenalty.getMultiplicand())) continue;
                MachineReassignmentIncrementalScoreCalculator.this.softScore += (minimumTargetAvailable - targetAvailable) * (long)balancePenalty.getWeight();
            }
        }
    }

    private class MrServiceScorePart {
        private final MrService service;
        private Map<MrLocation, Integer> locationBag;
        private Map<MrNeighborhood, Integer> neighborhoodBag;
        private int movedProcessCount;

        private MrServiceScorePart(MrService service) {
            this.service = service;
            this.locationBag = new HashMap<MrLocation, Integer>(MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getLocationList().size());
            MachineReassignmentIncrementalScoreCalculator.this.hardScore -= service.getLocationSpread();
            List<MrNeighborhood> neighborhoodList = MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getNeighborhoodList();
            this.neighborhoodBag = new HashMap<MrNeighborhood, Integer>(neighborhoodList.size());
            for (MrNeighborhood neighborhood : neighborhoodList) {
                this.neighborhoodBag.put(neighborhood, 0);
            }
            this.movedProcessCount = 0;
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            MrLocation location = processAssignment.getLocation();
            Integer locationProcessCount = this.locationBag.get(location);
            if (locationProcessCount == null) {
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += this.service.getLocationSpread() - this.locationBag.size();
                }
                this.locationBag.put(location, 1);
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= this.service.getLocationSpread() - this.locationBag.size();
                }
            } else {
                this.locationBag.put(location, locationProcessCount + 1);
            }
            MrNeighborhood neighborhood = processAssignment.getNeighborhood();
            int neighborhoodProcessCount = this.neighborhoodBag.get(neighborhood) + 1;
            this.neighborhoodBag.put(neighborhood, neighborhoodProcessCount);
            for (MrService toDependencyService : this.service.getToDependencyServiceList()) {
                int toDependencyNeighborhoodProcessCount = ((MrServiceScorePart)((MachineReassignmentIncrementalScoreCalculator)MachineReassignmentIncrementalScoreCalculator.this).serviceScorePartMap.get((Object)toDependencyService)).neighborhoodBag.get(neighborhood);
                if (toDependencyNeighborhoodProcessCount != 0) continue;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore--;
            }
            if (neighborhoodProcessCount == 1) {
                for (MrService fromDependencyService : this.service.getFromDependencyServiceList()) {
                    int fromDependencyNeighborhoodProcessCount = ((MrServiceScorePart)((MachineReassignmentIncrementalScoreCalculator)MachineReassignmentIncrementalScoreCalculator.this).serviceScorePartMap.get((Object)fromDependencyService)).neighborhoodBag.get(neighborhood);
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += fromDependencyNeighborhoodProcessCount;
                }
            }
            if (processAssignment.isMoved()) {
                int oldServiceCount = (Integer)MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, oldServiceCount - 1);
                if (MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost == this.movedProcessCount) {
                    MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost++;
                    MachineReassignmentIncrementalScoreCalculator.this.softScore -= MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getServiceMoveCostWeight();
                }
                ++this.movedProcessCount;
                Integer newServiceCount = (Integer)MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                if (newServiceCount == null) {
                    newServiceCount = 0;
                }
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, newServiceCount + 1);
            }
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            MrLocation location = processAssignment.getLocation();
            int locationProcessCount = this.locationBag.get(location);
            if (locationProcessCount == 1) {
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += this.service.getLocationSpread() - this.locationBag.size();
                }
                this.locationBag.remove(location);
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= this.service.getLocationSpread() - this.locationBag.size();
                }
            } else {
                this.locationBag.put(location, locationProcessCount - 1);
            }
            MrNeighborhood neighborhood = processAssignment.getNeighborhood();
            int neighborhoodProcessCount = this.neighborhoodBag.get(neighborhood) - 1;
            this.neighborhoodBag.put(neighborhood, neighborhoodProcessCount);
            for (MrService toDependencyService : this.service.getToDependencyServiceList()) {
                int toDependencyNeighborhoodProcessCount = ((MrServiceScorePart)((MachineReassignmentIncrementalScoreCalculator)MachineReassignmentIncrementalScoreCalculator.this).serviceScorePartMap.get((Object)toDependencyService)).neighborhoodBag.get(neighborhood);
                if (toDependencyNeighborhoodProcessCount != 0) continue;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore++;
            }
            if (neighborhoodProcessCount == 0) {
                for (MrService fromDependencyService : this.service.getFromDependencyServiceList()) {
                    int fromDependencyNeighborhoodProcessCount = ((MrServiceScorePart)((MachineReassignmentIncrementalScoreCalculator)MachineReassignmentIncrementalScoreCalculator.this).serviceScorePartMap.get((Object)fromDependencyService)).neighborhoodBag.get(neighborhood);
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= fromDependencyNeighborhoodProcessCount;
                }
            }
            if (processAssignment.isMoved()) {
                int oldServiceCount = (Integer)MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, oldServiceCount - 1);
                if (oldServiceCount == 1 && MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost == this.movedProcessCount) {
                    MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost--;
                    MachineReassignmentIncrementalScoreCalculator.this.softScore += MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getServiceMoveCostWeight();
                }
                --this.movedProcessCount;
                int newServiceCount = (Integer)MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, newServiceCount + 1);
            }
        }
    }
}

