/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRangeType;
import org.optaplanner.core.api.domain.value.ValueRanges;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.VrpAppearance;
import org.optaplanner.examples.vehiclerouting.domain.VrpLocation;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.solver.VrpCustomerDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=VrpCustomerDifficultyComparator.class)
@XStreamAlias(value="VrpCustomer")
public class VrpCustomer
extends AbstractPersistable
implements VrpAppearance {
    private VrpLocation location;
    private int demand;
    private VrpAppearance previousAppearance;

    @Override
    public VrpLocation getLocation() {
        return this.location;
    }

    public void setLocation(VrpLocation location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    @PlanningVariable(chained=true)
    @ValueRanges(value={@ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="vehicleList"), @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="customerList", excludeUninitializedPlanningEntity=true)})
    public VrpAppearance getPreviousAppearance() {
        return this.previousAppearance;
    }

    public void setPreviousAppearance(VrpAppearance previousAppearance) {
        this.previousAppearance = previousAppearance;
    }

    public VrpVehicle getVehicle() {
        VrpAppearance firstAppearance = this.getPreviousAppearance();
        while (firstAppearance instanceof VrpCustomer) {
            if (firstAppearance == this) {
                throw new IllegalStateException("Impossible state");
            }
            firstAppearance = ((VrpCustomer)firstAppearance).getPreviousAppearance();
        }
        return (VrpVehicle)firstAppearance;
    }

    public int getDistanceToPreviousAppearance() {
        if (this.previousAppearance == null) {
            return 0;
        }
        return this.getDistanceTo(this.previousAppearance);
    }

    public int getDistanceTo(VrpAppearance appearance) {
        return this.location.getDistance(appearance.getLocation());
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VrpCustomer) {
            VrpCustomer other = (VrpCustomer)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.location, (Object)other.location).append((Object)this.previousAppearance, (Object)other.previousAppearance).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.location).append((Object)this.previousAppearance).toHashCode();
    }

    @Override
    public String toString() {
        return this.location + "(after " + (this.previousAppearance == null ? "null" : this.previousAppearance.getLocation()) + ")";
    }
}

