/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator;

import java.util.Comparator;

import org.optaplanner.core.impl.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.optaplanner.core.api.score.Score;

/**
 * A DeciderScoreComparatorFactory creates a new DeciderScoreComparator each step,
 * which compares 2 scores to decide the next step.
 * That Score Comparator can consider shifting penalty, aging penalty, ...
 * in which case it differs from the natural ordering of scores.
 */
public interface DeciderScoreComparatorFactory extends LocalSearchSolverPhaseLifecycleListener {

    /**
     * @return never null
     */
    Comparator<Score> createDeciderScoreComparator();

}
