/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcess;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;
import org.optaplanner.examples.machinereassignment.domain.solver.MrServiceDependency;
import org.optaplanner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="MachineReassignment")
public class MachineReassignment
extends AbstractPersistable
implements Solution<HardSoftLongScore> {
    private MrGlobalPenaltyInfo globalPenaltyInfo;
    private List<MrResource> resourceList;
    private List<MrNeighborhood> neighborhoodList;
    private List<MrLocation> locationList;
    private List<MrMachine> machineList;
    private List<MrMachineCapacity> machineCapacityList;
    private List<MrService> serviceList;
    private List<MrProcess> processList;
    private List<MrBalancePenalty> balancePenaltyList;
    private List<MrProcessAssignment> processAssignmentList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftLongScoreDefinition.class})
    private HardSoftLongScore score;

    public MrGlobalPenaltyInfo getGlobalPenaltyInfo() {
        return this.globalPenaltyInfo;
    }

    public void setGlobalPenaltyInfo(MrGlobalPenaltyInfo globalPenaltyInfo) {
        this.globalPenaltyInfo = globalPenaltyInfo;
    }

    public List<MrResource> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<MrResource> resourceList) {
        this.resourceList = resourceList;
    }

    public List<MrNeighborhood> getNeighborhoodList() {
        return this.neighborhoodList;
    }

    public void setNeighborhoodList(List<MrNeighborhood> neighborhoodList) {
        this.neighborhoodList = neighborhoodList;
    }

    public List<MrLocation> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<MrLocation> locationList) {
        this.locationList = locationList;
    }

    public List<MrMachine> getMachineList() {
        return this.machineList;
    }

    public void setMachineList(List<MrMachine> machineList) {
        this.machineList = machineList;
    }

    public List<MrMachineCapacity> getMachineCapacityList() {
        return this.machineCapacityList;
    }

    public void setMachineCapacityList(List<MrMachineCapacity> machineCapacityList) {
        this.machineCapacityList = machineCapacityList;
    }

    public List<MrService> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<MrService> serviceList) {
        this.serviceList = serviceList;
    }

    public List<MrProcess> getProcessList() {
        return this.processList;
    }

    public void setProcessList(List<MrProcess> processList) {
        this.processList = processList;
    }

    public List<MrBalancePenalty> getBalancePenaltyList() {
        return this.balancePenaltyList;
    }

    public void setBalancePenaltyList(List<MrBalancePenalty> balancePenaltyList) {
        this.balancePenaltyList = balancePenaltyList;
    }

    @PlanningEntityCollectionProperty
    public List<MrProcessAssignment> getProcessAssignmentList() {
        return this.processAssignmentList;
    }

    public void setProcessAssignmentList(List<MrProcessAssignment> processAssignmentList) {
        this.processAssignmentList = processAssignmentList;
    }

    @Override
    public HardSoftLongScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Serializable> facts = new ArrayList<Serializable>();
        facts.add(this.globalPenaltyInfo);
        facts.addAll(this.resourceList);
        facts.addAll(this.neighborhoodList);
        facts.addAll(this.locationList);
        facts.addAll(this.machineList);
        facts.addAll(this.machineCapacityList);
        facts.addAll(this.serviceList);
        facts.addAll(this.createServiceDependencyList());
        facts.addAll(this.processList);
        facts.addAll(this.balancePenaltyList);
        return facts;
    }

    private List<MrServiceDependency> createServiceDependencyList() {
        ArrayList<MrServiceDependency> serviceDependencyList = new ArrayList<MrServiceDependency>(this.serviceList.size() * 5);
        for (MrService service : this.serviceList) {
            for (MrService toService : service.getToDependencyServiceList()) {
                MrServiceDependency serviceDependency = new MrServiceDependency();
                serviceDependency.setFromService(service);
                serviceDependency.setToService(toService);
                serviceDependencyList.add(serviceDependency);
            }
        }
        return serviceDependencyList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof MachineReassignment)) {
            return false;
        }
        MachineReassignment other = (MachineReassignment)o;
        if (this.processAssignmentList.size() != other.processAssignmentList.size()) {
            return false;
        }
        Iterator<MrProcessAssignment> it = this.processAssignmentList.iterator();
        Iterator<MrProcessAssignment> otherIt = other.processAssignmentList.iterator();
        while (it.hasNext()) {
            MrProcessAssignment otherProcessAssignment;
            MrProcessAssignment processAssignment = it.next();
            if (processAssignment.solutionEquals(otherProcessAssignment = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (MrProcessAssignment processAssignment : this.processAssignmentList) {
            hashCodeBuilder.append(processAssignment.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

