/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.SolverBenchmark;
import org.optaplanner.benchmark.impl.report.WebsiteResourceUtils;
import org.optaplanner.benchmark.impl.statistic.MillisecondsSpendNumberFormat;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.ScoreUtils;

public class BenchmarkReport {
    public static final int CHARTED_SCORE_LEVEL_SIZE = 5;
    protected final DefaultPlannerBenchmark plannerBenchmark;
    protected Locale locale;
    protected File htmlOverviewFile = null;
    protected File summaryDirectory = null;
    protected List<File> bestScoreSummaryChartFileList = null;
    protected List<File> bestScoreScalabilitySummaryChartFileList = null;
    protected List<File> winningScoreDifferenceSummaryChartFileList = null;
    protected List<File> worstScoreDifferencePercentageSummaryChartFileList = null;
    protected File timeSpendSummaryChartFile = null;
    protected File timeSpendScalabilitySummaryChartFile = null;
    protected File averageCalculateCountSummaryChartFile = null;
    protected Integer defaultShownScoreLevelIndex = null;
    protected List<String> warningList = null;

    public BenchmarkReport(DefaultPlannerBenchmark plannerBenchmark) {
        this.plannerBenchmark = plannerBenchmark;
    }

    public DefaultPlannerBenchmark getPlannerBenchmark() {
        return this.plannerBenchmark;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public File getHtmlOverviewFile() {
        return this.htmlOverviewFile;
    }

    public File getSummaryDirectory() {
        return this.summaryDirectory;
    }

    public List<File> getBestScoreSummaryChartFileList() {
        return this.bestScoreSummaryChartFileList;
    }

    public List<File> getBestScoreScalabilitySummaryChartFileList() {
        return this.bestScoreScalabilitySummaryChartFileList;
    }

    public List<File> getWinningScoreDifferenceSummaryChartFileList() {
        return this.winningScoreDifferenceSummaryChartFileList;
    }

    public List<File> getWorstScoreDifferencePercentageSummaryChartFileList() {
        return this.worstScoreDifferencePercentageSummaryChartFileList;
    }

    public File getTimeSpendSummaryChartFile() {
        return this.timeSpendSummaryChartFile;
    }

    public File getTimeSpendScalabilitySummaryChartFile() {
        return this.timeSpendScalabilitySummaryChartFile;
    }

    public File getAverageCalculateCountSummaryChartFile() {
        return this.averageCalculateCountSummaryChartFile;
    }

    public Integer getDefaultShownScoreLevelIndex() {
        return this.defaultShownScoreLevelIndex;
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public String getJavaVersion() {
        return "Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
    }

    public String getJavaVM() {
        return "Java " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")";
    }

    public String getOperatingSystem() {
        return System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
    }

    public String getPlannerVersion() {
        return SolverFactory.class.getPackage().getImplementationVersion();
    }

    public void writeReport() {
        this.summaryDirectory = new File(this.plannerBenchmark.getBenchmarkReportDirectory(), "summary");
        this.summaryDirectory.mkdir();
        this.fillWarningList();
        this.writeBestScoreSummaryCharts();
        this.writeBestScoreScalabilitySummaryChart();
        this.writeWinningScoreDifferenceSummaryChart();
        this.writeWorstScoreDifferencePercentageSummaryChart();
        this.writeTimeSpendSummaryChart();
        this.writeTimeSpendScalabilitySummaryChart();
        this.writeAverageCalculateCountPerSecondSummaryChart();
        for (ProblemBenchmark problemBenchmark : this.plannerBenchmark.getUnifiedProblemBenchmarkList()) {
            if (!problemBenchmark.hasAnySuccess()) continue;
            for (ProblemStatistic problemStatistic : problemBenchmark.getProblemStatisticList()) {
                problemStatistic.writeStatistic();
            }
        }
        this.determineDefaultShownScoreLevelIndex();
        this.writeHtmlOverviewFile();
    }

    protected void fillWarningList() {
        this.warningList = new ArrayList<String>();
        String javaVmName = System.getProperty("java.vm.name");
        if (javaVmName != null && javaVmName.contains("Client VM")) {
            this.warningList.add("The Java VM (" + javaVmName + ") is the Client VM." + " Consider starting the java process with the argument \"-server\" to get better results.");
        }
        int availableProcessors = this.getAvailableProcessors();
        if (this.plannerBenchmark.getParallelBenchmarkCount() > availableProcessors) {
            this.warningList.add("The parallelBenchmarkCount (" + this.plannerBenchmark.getParallelBenchmarkCount() + ") is higher than the number of availableProcessors (" + availableProcessors + ").");
        }
    }

    private void writeBestScoreSummaryCharts() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmark.getScore());
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.bestScoreSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScoreSummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScoreSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeBestScoreScalabilitySummaryChart() {
        ArrayList seriesListList = new ArrayList(5);
        int solverBenchmarkIndex = 0;
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String string = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                long problemScale = singleBenchmark.getProblemBenchmark().getProblemScale();
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmark.getScore());
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    List seriesList;
                    if (i >= seriesListList.size()) {
                        seriesListList.add(new ArrayList(this.plannerBenchmark.getSolverBenchmarkList().size()));
                    }
                    if (solverBenchmarkIndex >= (seriesList = (List)seriesListList.get(i)).size()) {
                        seriesList.add(new XYSeries((Comparable)((Object)string)));
                    }
                    ((XYSeries)seriesList.get(solverBenchmarkIndex)).add((double)problemScale, levelValues[i]);
                }
            }
            ++solverBenchmarkIndex;
        }
        this.bestScoreScalabilitySummaryChartFileList = new ArrayList<File>(seriesListList.size());
        int scoreLevelIndex = 0;
        for (List list : seriesListList) {
            XYPlot plot = this.createScalabilityPlot(list, "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score scalability level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScoreScalabilitySummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScoreScalabilitySummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWinningScoreDifferenceSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = ScoreUtils.extractLevelDoubles((Score)singleBenchmark.getWinningScoreDifference());
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.winningScoreDifferenceSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Winning score difference level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Winning score difference level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.winningScoreDifferenceSummaryChartFileList.add(this.writeChartToImageFile(chart, "winningScoreDifferenceSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWorstScoreDifferencePercentageSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = singleBenchmark.getWorstScoreDifferencePercentage().getPercentageLevels();
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.worstScoreDifferencePercentageSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Worst score difference percentage level " + scoreLevelIndex, NumberFormat.getPercentInstance(this.locale));
            JFreeChart chart = new JFreeChart("Worst score difference percentage level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.worstScoreDifferencePercentageSummaryChartFileList.add(this.writeChartToImageFile(chart, "worstScoreDifferencePercentageSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeTimeSpendSummaryChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                long timeMillisSpend = singleBenchmark.getTimeMillisSpend();
                dataset.addValue((double)timeMillisSpend, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryPlot plot = this.createBarChartPlot(dataset, "Time spend", new MillisecondsSpendNumberFormat(this.locale));
        JFreeChart chart = new JFreeChart("Time spend summary (lower time is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.timeSpendSummaryChartFile = this.writeChartToImageFile(chart, "timeSpendSummary");
    }

    private void writeTimeSpendScalabilitySummaryChart() {
        ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(this.plannerBenchmark.getSolverBenchmarkList().size());
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                long problemScale = singleBenchmark.getProblemBenchmark().getProblemScale();
                long timeMillisSpend = singleBenchmark.getTimeMillisSpend();
                series.add((Number)problemScale, (Number)timeMillisSpend);
            }
            seriesList.add(series);
        }
        XYPlot plot = this.createScalabilityPlot(seriesList, "Time spend", new MillisecondsSpendNumberFormat(this.locale));
        JFreeChart chart = new JFreeChart("Time spend scalability summary (lower is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.timeSpendScalabilitySummaryChartFile = this.writeChartToImageFile(chart, "timeSpendScalabilitySummary");
    }

    private void writeAverageCalculateCountPerSecondSummaryChart() {
        ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(this.plannerBenchmark.getSolverBenchmarkList().size());
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                long problemScale = singleBenchmark.getProblemBenchmark().getProblemScale();
                long averageCalculateCountPerSecond = singleBenchmark.getAverageCalculateCountPerSecond();
                series.add((Number)problemScale, (Number)averageCalculateCountPerSecond);
            }
            seriesList.add(series);
        }
        XYPlot plot = this.createScalabilityPlot(seriesList, "Average calculate count per second", NumberFormat.getInstance(this.locale));
        JFreeChart chart = new JFreeChart("Average calculate count summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.averageCalculateCountSummaryChartFile = this.writeChartToImageFile(chart, "averageCalculateCountSummary");
    }

    private CategoryPlot createBarChartPlot(DefaultCategoryDataset dataset, String yAxisLabel, NumberFormat numberFormat) {
        CategoryAxis xAxis = new CategoryAxis("Data");
        xAxis.setCategoryMargin(0.4);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setNumberFormatOverride(numberFormat);
        BarRenderer renderer = this.createBarChartRenderer(numberFormat);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private BarRenderer createBarChartRenderer(NumberFormat numberFormat) {
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", numberFormat));
        renderer.setBaseItemLabelsVisible(true);
        return renderer;
    }

    private XYPlot createScalabilityPlot(List<XYSeries> seriesList, String yAxisLabel, NumberFormat numberFormat) {
        NumberAxis xAxis = new NumberAxis("Problem scale");
        xAxis.setNumberFormatOverride(NumberFormat.getInstance(this.locale));
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setNumberFormatOverride(numberFormat);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (XYSeries series : seriesList) {
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            XYItemRenderer renderer = this.createScalabilityPlotRenderer(numberFormat);
            plot.setRenderer(seriesIndex, renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private XYItemRenderer createScalabilityPlotRenderer(NumberFormat numberFormat) {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
        return renderer;
    }

    private File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File summaryChartFile = new File(this.summaryDirectory, fileNameBase + ".png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(summaryChartFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing summaryChartFile: " + summaryChartFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return summaryChartFile;
    }

    private void determineDefaultShownScoreLevelIndex() {
        this.defaultShownScoreLevelIndex = Integer.MAX_VALUE;
        for (ProblemBenchmark problemBenchmark : this.plannerBenchmark.getUnifiedProblemBenchmarkList()) {
            if (!problemBenchmark.hasAnySuccess()) continue;
            double[] winningScoreLevels = ScoreUtils.extractLevelDoubles((Score)problemBenchmark.getWinningSingleBenchmark().getScore());
            int[] differenceCount = new int[winningScoreLevels.length];
            for (int i = 0; i < differenceCount.length; ++i) {
                differenceCount[i] = 0;
            }
            for (SingleBenchmark singleBenchmark : problemBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                double[] scoreLevels = ScoreUtils.extractLevelDoubles((Score)singleBenchmark.getScore());
                for (int i = 0; i < scoreLevels.length; ++i) {
                    if (scoreLevels[i] == winningScoreLevels[i]) continue;
                    differenceCount[i] = differenceCount[i] + 1;
                }
            }
            int firstInterestingLevel = differenceCount.length - 1;
            for (int i = 0; i < differenceCount.length; ++i) {
                if (differenceCount[i] <= 0) continue;
                firstInterestingLevel = i;
                break;
            }
            if (this.defaultShownScoreLevelIndex <= firstInterestingLevel) continue;
            this.defaultShownScoreLevelIndex = firstInterestingLevel;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeHtmlOverviewFile() {
        WebsiteResourceUtils.copyResourcesTo(this.plannerBenchmark.getBenchmarkReportDirectory());
        this.htmlOverviewFile = new File(this.plannerBenchmark.getBenchmarkReportDirectory(), "index.html");
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setLocale(this.locale);
        freemarkerCfg.setClassForTemplateLoading(BenchmarkReport.class, "");
        String templateFilename = "benchmarkReport.html.ftl";
        HashMap<String, BenchmarkReport> model = new HashMap<String, BenchmarkReport>();
        model.put("benchmarkReport", this);
        OutputStreamWriter writer = null;
        try {
            Template template = freemarkerCfg.getTemplate(templateFilename);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOverviewFile), "UTF-8");
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write htmlOverviewFile (" + this.htmlOverviewFile + ").", e);
                catch (TemplateException e2) {
                    throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to htmlOverviewFile (" + this.htmlOverviewFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

