/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestscore;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.statistic.AbstractProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.MillisecondsSpendNumberFormat;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreSingleStatisticPoint;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;

public class BestScoreProblemStatistic
extends AbstractProblemStatistic {
    protected List<File> graphStatisticFileList = null;

    public BestScoreProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.BEST_SOLUTION_CHANGED);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new BestScoreSingleStatistic();
    }

    public List<String> getGraphFilePathList() {
        ArrayList<String> graphFilePathList = new ArrayList<String>(this.graphStatisticFileList.size());
        for (File graphStatisticFile : this.graphStatisticFileList) {
            graphFilePathList.add(this.toFilePath(graphStatisticFile));
        }
        return graphFilePathList;
    }

    @Override
    protected void writeCsvStatistic() {
        AbstractProblemStatistic.ProblemStatisticCsv csv = new AbstractProblemStatistic.ProblemStatisticCsv();
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            if (singleBenchmark.isSuccess()) {
                BestScoreSingleStatistic singleStatistic = (BestScoreSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (BestScoreSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    Score score = point.getScore();
                    if (score == null) continue;
                    csv.addPoint(singleBenchmark, timeMillisSpend, score.toString());
                }
                continue;
            }
            csv.addPoint(singleBenchmark, 0L, "Failed");
        }
        this.csvStatisticFile = new File(this.problemBenchmark.getProblemReportDirectory(), this.problemBenchmark.getName() + "BestScoreStatistic.csv");
        csv.writeCsvStatisticFile();
    }

    @Override
    protected void writeGraphStatistic() {
        ArrayList<XYPlot> plotList = new ArrayList<XYPlot>(5);
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(5);
            XYStepRenderer renderer = new XYStepRenderer();
            if (singleBenchmark.isSuccess()) {
                BestScoreSingleStatistic singleStatistic = (BestScoreSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (BestScoreSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    double[] levelValues = ScoreUtils.extractLevelDoubles((Score)point.getScore());
                    for (int i = 0; i < levelValues.length && i < 5; ++i) {
                        if (i >= seriesList.size()) {
                            seriesList.add(new XYSeries((Comparable)((Object)singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix())));
                        }
                        ((XYSeries)seriesList.get(i)).add((double)timeMillisSpend, levelValues[i]);
                    }
                }
                long timeMillisSpend = singleBenchmark.getTimeMillisSpend();
                double[] bestScoreLevels = ScoreUtils.extractLevelDoubles((Score)singleBenchmark.getScore());
                for (int i = 0; i < bestScoreLevels.length && i < 5; ++i) {
                    if (i >= seriesList.size()) {
                        seriesList.add(new XYSeries((Comparable)((Object)singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix())));
                    }
                    ((XYSeries)seriesList.get(i)).add((double)timeMillisSpend, bestScoreLevels[i]);
                }
                if (singleStatistic.getPointList().size() <= 1) {
                    renderer = new StandardXYItemRenderer(3);
                }
            }
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            for (int i = 0; i < seriesList.size(); ++i) {
                if (i >= plotList.size()) {
                    plotList.add(this.createPlot(i));
                }
                ((XYPlot)plotList.get(i)).setDataset(seriesIndex, (XYDataset)new XYSeriesCollection((XYSeries)seriesList.get(i)));
                ((XYPlot)plotList.get(i)).setRenderer(seriesIndex, (XYItemRenderer)renderer);
            }
            ++seriesIndex;
        }
        this.graphStatisticFileList = new ArrayList<File>(plotList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < plotList.size(); ++scoreLevelIndex) {
            JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " best score level " + scoreLevelIndex + " statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plotList.get(scoreLevelIndex), true);
            this.graphStatisticFileList.add(this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "BestScoreStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(int scoreLevelIndex) {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Score level " + scoreLevelIndex);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

