/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Comparator;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.LeftTupleList;

public class RuleExecutor {
    private static RuleNetworkEvaluator networkEvaluator = new RuleNetworkEvaluator();
    private PathMemory pmem;
    private RuleAgendaItem ruleAgendaItem;
    private LeftTupleList tupleList;
    private BinaryHeapQueue queue;
    private boolean dirty;
    private boolean declarativeAgendaEnabled;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new LeftTupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        if (ruleAgendaItem.getRule().getSalience().isDynamic()) {
            this.queue = new BinaryHeapQueue(SalienceComparator.INSTANCE);
        }
    }

    public void evaluateNetwork(InternalWorkingMemory wm) {
        networkEvaluator.evaluateNetwork(this.pmem, null, this, wm);
        this.setDirty(false);
        wm.executeQueuedActions();
    }

    public int evaluateNetworkAndFire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit) {
        LinkedList<StackEntry> outerStack = new LinkedList<StackEntry>();
        if (this.dirty) {
            networkEvaluator.evaluateNetwork(this.pmem, outerStack, this, wm);
            this.setDirty(false);
            wm.executeQueuedActions();
        }
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getNetworkNode();
            InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
            int salience = this.ruleAgendaItem.getSalience();
            if (this.isDeclarativeAgendaEnabled() && !this.isHighestSalience(nextRule = agenda.peekNextRule(), salience)) {
                return localFireCount;
            }
            while (!this.tupleList.isEmpty()) {
                RuleAgendaItem nextRule2;
                LeftTuple leftTuple;
                if (this.queue != null) {
                    leftTuple = (LeftTuple)((Object)this.queue.dequeue());
                    this.tupleList.remove(leftTuple);
                } else {
                    leftTuple = this.tupleList.removeFirst();
                }
                rtn = (RuleTerminalNode)leftTuple.getSink();
                Rule rule = rtn.getRule();
                PropagationContext pctx = leftTuple.getPropagationContext();
                pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
                if (this.isNotEffective(wm, rtn, rule, leftTuple, pctx)) continue;
                AgendaItem item = (AgendaItem)((Object)leftTuple);
                if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(item, pctx, wm, rtn)) continue;
                if (filter == null || filter.accept(item)) {
                    agenda.fireActivation(item);
                    ++localFireCount;
                }
                salience = this.ruleAgendaItem.getSalience();
                if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                    this.ruleAgendaItem.dequeue();
                    this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                    this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                    salience = this.ruleAgendaItem.getSalience();
                }
                if (this.haltRuleFiring(nextRule2 = agenda.peekNextRule(), fireCount, fireLimit, localFireCount, agenda, salience)) break;
                if (this.isDirty()) {
                    this.setDirty(false);
                    networkEvaluator.evaluateNetwork(this.pmem, outerStack, this, wm);
                }
                wm.executeQueuedActions();
                if (!this.tupleList.isEmpty() || outerStack.isEmpty()) continue;
                StackEntry entry = outerStack.removeFirst();
                networkEvaluator.evalStackEntry(entry, outerStack, outerStack, this, wm);
            }
        }
        if (!this.dirty && this.tupleList.isEmpty()) {
            this.ruleAgendaItem.remove();
            if (this.ruleAgendaItem.getRule().isEager()) {
                ((InternalAgenda)wm.getAgenda()).removeEagerRuleAgendaItem(this.ruleAgendaItem);
            }
        }
        return localFireCount;
    }

    public RuleTerminalNodeLeftTuple removeFirstLeftTuple() {
        RuleTerminalNodeLeftTuple lt;
        if (this.queue == null) {
            lt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
        } else {
            lt = (RuleTerminalNodeLeftTuple)this.queue.dequeue();
            this.removeQueuedLeftTuple(lt);
        }
        return lt;
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean isNotEffective(InternalWorkingMemory wm, RuleTerminalNode rtn, Rule rule, LeftTuple leftTuple, PropagationContext pctx) {
        if (!rule.isEffective(leftTuple, rtn, wm) || rule.isNoLoop() && rule.equals(pctx.getRuleOrigin())) {
            return true;
        }
        if (rule.getCalendars() != null) {
            long timestamp = wm.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (wm.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haltRuleFiring(RuleAgendaItem nextRule, int fireCount, int fireLimit, int localFireCount, InternalAgenda agenda, int salience) {
        return !agenda.continueFiring(0) || !this.isHighestSalience(nextRule, salience) || fireLimit >= 0 && localFireCount + fireCount >= fireLimit;
    }

    public boolean isHighestSalience(RuleAgendaItem nextRule, int currentSalience) {
        return nextRule == null || nextRule.getSalience() <= currentSalience;
    }

    public void addLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(true);
        this.tupleList.add(leftTuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(leftTuple);
        }
    }

    public void addQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((Activation)((Object)leftTuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(false);
        this.tupleList.remove(leftTuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(leftTuple);
        }
    }

    public void removeQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue(((Activation)((Object)leftTuple)).getQueueIndex());
        this.updateSalience(currentSalience);
    }

    public void updateLeftTuple(RuleTerminalNodeLeftTuple leftTuple, int salience, PropagationContext pctx) {
        if (salience != leftTuple.getSalience()) {
            int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
            leftTuple.dequeue();
            this.queue.enqueue(leftTuple);
            this.updateSalience(currentSalience);
        }
        leftTuple.update(salience, pctx);
    }

    private void updateSalience(int currentSalience) {
        int newSalience = this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    public static class SalienceComparator
    implements Comparator {
        public static final SalienceComparator INSTANCE = new SalienceComparator();

        public int compare(Object existing, Object adding) {
            int s2;
            RuleTerminalNodeLeftTuple rtnLt1 = (RuleTerminalNodeLeftTuple)existing;
            RuleTerminalNodeLeftTuple rtnLt2 = (RuleTerminalNodeLeftTuple)adding;
            int s1 = rtnLt1.getSalience();
            if (s1 > (s2 = rtnLt2.getSalience())) {
                return 1;
            }
            if (s1 < s2) {
                return -1;
            }
            return 0;
        }
    }
}

