/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.phreak.PhreakBranchNode;
import org.drools.core.phreak.PhreakEvalNode;
import org.drools.core.phreak.PhreakExistsNode;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.PhreakQueryNode;
import org.drools.core.phreak.PhreakQueryTerminalNode;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluator.class);
    private static PhreakJoinNode pJoinNode = new PhreakJoinNode();
    private static PhreakEvalNode pEvalNode = new PhreakEvalNode();
    private static PhreakFromNode pFromNode = new PhreakFromNode();
    private static PhreakNotNode pNotNode = new PhreakNotNode();
    private static PhreakExistsNode pExistsNode = new PhreakExistsNode();
    private static PhreakAccumulateNode pAccNode = new PhreakAccumulateNode();
    private static PhreakBranchNode pBranchNode = new PhreakBranchNode();
    private static PhreakQueryNode pQueryNode = new PhreakQueryNode();
    private static PhreakTimerNode pTimerNode = new PhreakTimerNode();
    private static PhreakRuleTerminalNode pRtNode = new PhreakRuleTerminalNode();
    private static int cycle = 0;
    private static PhreakQueryTerminalNode pQtNode = new PhreakQueryTerminalNode();

    public int evaluateNetwork(PathMemory pmem, LinkedList<StackEntry> outerStack, RuleExecutor executor, InternalWorkingMemory wm) {
        Memory nodeMem;
        NetworkNode node;
        int smemIndex;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory smem = smems[smemIndex = 0];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        if (liaNode == smem.getTipNode()) {
            smem = smems[++smemIndex];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        } else {
            node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
            nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
        }
        LeftTupleSets srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            log.trace("Rule[name={}] segments={} {}", new Object[]{((TerminalNode)pmem.getNetworkNode()).getRule().getName(), smems.length, srcTuples.toStringSizes()});
        }
        Set<String> visitedRules = ((TerminalNode)pmem.getNetworkNode()).getType() == 91 ? new HashSet() : Collections.emptySet();
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        this.outerEval(liaNode, pmem, node, nodeMem, smems, smemIndex, srcTuples, wm, stack, outerStack, visitedRules, true, executor);
        return 0;
    }

    public static String indent(int size) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sbuilder.append("  ");
        }
        return sbuilder.toString();
    }

    public static int getOffset(NetworkNode node) {
        LeftTupleSource lt = null;
        int offset = 1;
        if (NodeTypeEnums.isTerminalNode(node)) {
            lt = ((TerminalNode)node).getLeftTupleSource();
            ++offset;
        } else {
            lt = node.getType() == 71 ? ((RightInputAdapterNode)node).getLeftTupleSource() : (LeftTupleSource)node;
        }
        while (lt.getType() != 120) {
            ++offset;
            lt = lt.getLeftTupleSource();
        }
        return offset;
    }

    public void outerEval(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor) {
        this.innerEval(liaNode, pmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor);
        while (!stack.isEmpty()) {
            StackEntry entry = stack.removeLast();
            this.evalStackEntry(entry, stack, outerStack, executor, wm);
        }
    }

    public void evalStackEntry(StackEntry entry, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, RuleExecutor executor, InternalWorkingMemory wm) {
        NetworkNode node = entry.getNode();
        Memory nodeMem = entry.getNodeMem();
        LeftTupleSets trgTuples = entry.getTrgTuples();
        if (node.getType() == 165) {
            trgTuples.addAll(((QueryElementNode.QueryElementNodeMemory)nodeMem).getResultLeftTuples());
        }
        LeftTupleSinkNode sink = entry.getSink();
        PathMemory pmem = entry.getRmem();
        SegmentMemory[] smems = entry.getSmems();
        int smemIndex = entry.getSmemIndex();
        Set<String> visitedRules = entry.getVisitedRules();
        boolean processRian = !NodeTypeEnums.isBetaNode(node);
        if (entry.isResumeFromNextNode()) {
            SegmentMemory smem = smems[smemIndex];
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
            } else {
                SegmentPropagator.propagate(smem, trgTuples, wm);
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples();
                node = (LeftTupleSink)smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
        }
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} Resume {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), node.toString(), trgTuples.toStringSizes()});
        }
        this.innerEval(entry.getLiaNode(), pmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void innerEval(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor) {
        SegmentMemory smem = smems[smemIndex];
        while (true) {
            boolean exitInnerEval;
            LeftTupleSets stagedLeftTuples;
            LeftTupleSets srcTuples = trgTuples;
            if (log.isTraceEnabled()) {
                int offset = RuleNetworkEvaluator.getOffset(node);
                log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), ++cycle, node.toString(), srcTuples.toStringSizes()});
            }
            if (NodeTypeEnums.isTerminalNode(node)) {
                TerminalNode rtn = (TerminalNode)node;
                if (node.getType() == 91) {
                    pQtNode.doNode((QueryTerminalNode)rtn, wm, srcTuples, stack);
                } else {
                    pRtNode.doNode(rtn, wm, srcTuples, executor);
                }
                return;
            }
            if (71 == node.getType()) {
                this.doRiaNode2(wm, srcTuples, (RightInputAdapterNode)node, stack);
                return;
            }
            if (node == smem.getTipNode()) {
                if (smem.isEmpty()) {
                    SegmentMemory segmentMemory = smem;
                    synchronized (segmentMemory) {
                        if (smem.isEmpty()) {
                            SegmentUtilities.createChildSegments(wm, smem, ((LeftTupleSource)node).getSinkPropagator());
                        }
                        stagedLeftTuples = ((SegmentMemory)smem.getFirst()).getStagedLeftTuples();
                    }
                } else {
                    stagedLeftTuples = ((SegmentMemory)smem.getFirst()).getStagedLeftTuples();
                }
            } else {
                stagedLeftTuples = null;
            }
            LeftTupleSinkNode sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
            trgTuples = new LeftTupleSets();
            if (NodeTypeEnums.isBetaNode(node)) {
                exitInnerEval = this.evalBetaNode(liaNode, pmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor, srcTuples, stagedLeftTuples, sink);
                if (exitInnerEval) {
                    return;
                }
            } else {
                switch (node.getType()) {
                    case 131: {
                        if (stagedLeftTuples != null) {
                            LeftTupleSets exitInnerEval2 = stagedLeftTuples;
                            synchronized (exitInnerEval2) {
                                pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                                break;
                            }
                        }
                        pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 151: {
                        if (stagedLeftTuples != null) {
                            LeftTupleSets exitInnerEval2 = stagedLeftTuples;
                            synchronized (exitInnerEval2) {
                                pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                                break;
                            }
                        }
                        pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 165: {
                        exitInnerEval = this.evalQueryNode(liaNode, pmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, visitedRules, srcTuples, sink);
                        if (!exitInnerEval) break;
                        return;
                    }
                    case 133: {
                        if (stagedLeftTuples != null) {
                            LeftTupleSets leftTupleSets = stagedLeftTuples;
                            synchronized (leftTupleSets) {
                                pTimerNode.doNode((TimerNode)node, (TimerNode.TimerNodeMemory)nodeMem, pmem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                                break;
                            }
                        }
                        pTimerNode.doNode((TimerNode)node, (TimerNode.TimerNodeMemory)nodeMem, pmem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 167: {
                        if (stagedLeftTuples != null) {
                            LeftTupleSets leftTupleSets = stagedLeftTuples;
                            synchronized (leftTupleSets) {
                                pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples, executor);
                                break;
                            }
                        }
                        pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples, executor);
                    }
                }
            }
            if (node != smem.getTipNode()) {
                node = sink;
                nodeMem = (Memory)nodeMem.getNext();
            } else {
                LeftTupleSets leftTupleSets = stagedLeftTuples;
                synchronized (leftTupleSets) {
                    SegmentPropagator.propagate(smem, trgTuples, wm);
                    smem = smems[++smemIndex];
                    trgTuples = smem.getStagedLeftTuples().cloneAndReset();
                }
                if (log.isTraceEnabled()) {
                    log.trace("Segment {}", (Object)smemIndex);
                }
                node = (LeftTupleSink)smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
            processRian = true;
        }
    }

    private boolean evalQueryNode(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, Set<String> visitedRules, LeftTupleSets srcTuples, LeftTupleSinkNode sink) {
        QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
        if (srcTuples.isEmpty() && qmem.getResultLeftTuples().isEmpty()) {
            return false;
        }
        QueryElementNode qnode = (QueryElementNode)node;
        if (visitedRules == Collections.emptySet()) {
            visitedRules = new HashSet<String>();
        }
        visitedRules.add(qnode.getQueryElement().getQueryName());
        trgTuples.addAll(qmem.getResultLeftTuples());
        if (!srcTuples.isEmpty()) {
            StackEntry stackEntry = new StackEntry(liaNode, node, sink, pmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, true);
            stack.add(stackEntry);
            pQueryNode.doNode(qnode, (QueryElementNode.QueryElementNodeMemory)nodeMem, stackEntry, sink, wm, srcTuples);
            SegmentMemory qsmem = ((QueryElementNode.QueryElementNodeMemory)nodeMem).getQuerySegmentMemory();
            List<PathMemory> qpmems = qsmem.getPathMemories();
            for (int i = 0; i < qpmems.size(); ++i) {
                PathMemory qpmem;
                pmem = qpmem = qpmems.get(i);
                smems = qpmem.getSegmentMemories();
                SegmentMemory smem = smems[smemIndex = 0];
                liaNode = (LeftInputAdapterNode)smem.getRootNode();
                if (liaNode == smem.getTipNode()) {
                    smem = smems[++smemIndex];
                    node = smem.getRootNode();
                    nodeMem = smem.getNodeMemories().getFirst();
                } else {
                    node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
                }
                trgTuples = smem.getStagedLeftTuples();
                stackEntry = new StackEntry(liaNode, node, null, pmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, false);
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(stackEntry.getNode());
                    log.trace("{} ORQueue branch={} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), i, stackEntry.getNode().toString(), trgTuples.toStringSizes()});
                }
                stack.add(stackEntry);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean evalBetaNode(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor, LeftTupleSets srcTuples, LeftTupleSets stagedLeftTuples, LeftTupleSinkNode sink) {
        BetaNode betaNode = (BetaNode)node;
        BetaMemory bm = null;
        AccumulateNode.AccumulateMemory am = null;
        if (211 == node.getType()) {
            am = (AccumulateNode.AccumulateMemory)nodeMem;
            bm = am.getBetaMemory();
        } else {
            bm = (BetaMemory)nodeMem;
        }
        if (processRian && betaNode.isRightInputIsRiaNode()) {
            this.doRiaNode(wm, liaNode, pmem, srcTuples, betaNode, sink, smems, smemIndex, nodeMem, bm, stack, outerStack, visitedRules, executor);
            return true;
        }
        Deque<RightTuple> que = bm.getDequeu();
        if (!que.isEmpty()) {
            RightTupleSets rightTuples = bm.getStagedRightTuples();
            if (rightTuples.isEmpty()) {
                RightTuple rightTuple = que.peekFirst();
                PropagationContext pctx = rightTuple.getPropagationContext();
                block8: while (rightTuple != null && rightTuple.getPropagationContext() == pctx) {
                    switch (rightTuple.getPropagationContext().getType()) {
                        case 0: 
                        case 3: {
                            rightTuples.addInsert(rightTuple);
                            break;
                        }
                        case 2: {
                            rightTuples.addUpdate(rightTuple);
                            break;
                        }
                        case 1: 
                        case 4: {
                            rightTuples.addDelete(rightTuple);
                            break;
                        }
                        case 5: {
                            rightTuples.addDelete(rightTuple);
                            break block8;
                        }
                    }
                    que.removeFirst();
                    rightTuple = que.peekFirst();
                }
            }
            if (!que.isEmpty()) {
                StackEntry stackEntry = new StackEntry(liaNode, node, sink, pmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, false);
                outerStack.add(stackEntry);
            }
        }
        if (stagedLeftTuples != null) {
            LeftTupleSets leftTupleSets = stagedLeftTuples;
            synchronized (leftTupleSets) {
                this.switchOnDoBetaNode(node, trgTuples, wm, srcTuples, stagedLeftTuples, sink, bm, am);
                return false;
            }
        }
        this.switchOnDoBetaNode(node, trgTuples, wm, srcTuples, stagedLeftTuples, sink, bm, am);
        return false;
    }

    private void switchOnDoBetaNode(NetworkNode node, LeftTupleSets trgTuples, InternalWorkingMemory wm, LeftTupleSets srcTuples, LeftTupleSets stagedLeftTuples, LeftTupleSinkNode sink, BetaMemory bm, AccumulateNode.AccumulateMemory am) {
        switch (node.getType()) {
            case 181: {
                pJoinNode.doNode((JoinNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 191: {
                pNotNode.doNode((NotNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 201: {
                pExistsNode.doNode((ExistsNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 211: {
                pAccNode.doNode((AccumulateNode)node, sink, am, wm, srcTuples, trgTuples, stagedLeftTuples);
            }
        }
    }

    private void doRiaNode(InternalWorkingMemory wm, LeftInputAdapterNode liaNode, PathMemory pmem, LeftTupleSets srcTuples, BetaNode betaNode, LeftTupleSinkNode sink, SegmentMemory[] smems, int smemIndex, Memory nodeMem, BetaMemory bm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, RuleExecutor executor) {
        RiaPathMemory pathMem = bm.getRiaRuleMemory();
        SegmentMemory[] subnetworkSmems = pathMem.getSegmentMemories();
        SegmentMemory subSmem = null;
        int i = 0;
        while (subSmem == null) {
            subSmem = subnetworkSmems[i];
            ++i;
        }
        StackEntry stackEntry = new StackEntry(liaNode, betaNode, sink, pmem, nodeMem, smems, smemIndex, srcTuples, visitedRules, false);
        stack.add(stackEntry);
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(betaNode);
            log.trace("{} RiaQueue {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), betaNode.toString(), srcTuples.toStringSizes()});
        }
        this.innerEval(liaNode, pathMem, subSmem.getRootNode(), subSmem.getNodeMemories().getFirst(), subnetworkSmems, subSmem.getPos(), subSmem.getStagedLeftTuples(), wm, stack, outerStack, visitedRules, true, executor);
    }

    private void doRiaNode2(InternalWorkingMemory wm, LeftTupleSets srcTuples, RightInputAdapterNode riaNode, LinkedList<StackEntry> stack) {
        RightTupleSets rightTuples;
        RightTuple rightTuple;
        LeftTuple next;
        ObjectSink[] sinks = riaNode.getSinkPropagator().getSinks();
        BetaNode betaNode = (BetaNode)sinks[0];
        Memory nodeMem = wm.getNodeMemory(betaNode);
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem).getBetaMemory() : (BetaMemory)nodeMem;
        BetaNode[] bns = null;
        BetaMemory[] bms = null;
        int length = sinks.length;
        if (length > 1) {
            bns = new BetaNode[sinks.length - 1];
            bms = new BetaMemory[sinks.length - 1];
            for (int i = 1; i < length; ++i) {
                bns[i - 1] = (BetaNode)sinks[i];
                Memory nodeMem2 = wm.getNodeMemory(bns[i - 1]);
                bms[i - 1] = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem2).getBetaMemory() : (BetaMemory)nodeMem2;
            }
        }
        RightInputAdapterNode.RiaNodeMemory rnm = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory(riaNode);
        --length;
        LeftTuple leftTuple = srcTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            PropagationContext pctx = leftTuple.getPropagationContext();
            InternalFactHandle handle = riaNode.createFactHandle(leftTuple, pctx, wm);
            rnm.getMap().put(leftTuple, handle);
            RightTuple rightTuple2 = new RightTuple(handle, betaNode);
            leftTuple.setObject(rightTuple2);
            rightTuple2.setPropagationContext(pctx);
            bm.getStagedRightTuples().addInsert(rightTuple2);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple2 = new RightTuple(handle, bns[i]);
                    rightTuple2.setPropagationContext(pctx);
                    bms[i].getStagedRightTuples().addInsert(rightTuple2);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            rnm.getMap().remove(leftTuple);
            rightTuple = (RightTuple)leftTuple.getObject();
            rightTuples = bm.getStagedRightTuples();
            switch (rightTuple.getStagedType()) {
                case 1: {
                    rightTuples.removeInsert(rightTuple);
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(rightTuple);
                }
            }
            rightTuples.addDelete(rightTuple);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    switch (rightTuple.getStagedType()) {
                        case 1: {
                            rightTuples.removeInsert(rightTuple);
                            break;
                        }
                        case 2: {
                            rightTuples.removeUpdate(rightTuple);
                        }
                    }
                    rightTuples.addDelete(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            rightTuple = (RightTuple)leftTuple.getObject();
            rightTuples = bm.getStagedRightTuples();
            switch (rightTuple.getStagedType()) {
                case 1: {
                    rightTuples.removeInsert(rightTuple);
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(rightTuple);
                }
            }
            rightTuples.addUpdate(rightTuple);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    switch (rightTuple.getStagedType()) {
                        case 1: {
                            rightTuples.removeInsert(rightTuple);
                            break;
                        }
                        case 2: {
                            rightTuples.removeUpdate(rightTuple);
                        }
                    }
                    rightTuples.addUpdate(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        srcTuples.resetAll();
    }

    public boolean isRuleExecutor() {
        return true;
    }

    public static void findLeftTupleBlocker(BetaNode betaNode, RightTupleMemory rtm, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTuple leftTuple, FastIterator it, PropagationContext context, boolean useLeftMemory) {
        RightTuple rightTuple = betaNode.getFirstRightTuple(leftTuple, rtm, null, it);
        while (rightTuple != null) {
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (useLeftMemory) {
                    rightTuple.addBlocked(leftTuple);
                    break;
                }
                if (!betaNode.isRightInputIsRiaNode()) break;
                rtm.remove(rightTuple);
            }
            rightTuple = nextRight;
        }
    }

    public static LeftTuple deleteLeftChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getLeftParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static LeftTuple deleteRightChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getRightParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static void dpUpdatesReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.remove(leftTuple);
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.add(leftTuple);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                LeftTuple childNext = childLeftTuple.getLeftParentNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
            leftTuple = next;
        }
    }

    public static void dpUpdatesExistentialReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                ltm.add(leftTuple);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getLeftParentNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
            } else if (blocker.getStagedType() != 0) {
                blocker.removeBlocked(leftTuple);
            }
            leftTuple = next;
        }
    }

    public static void dpUpdatesReorderRightMemory(BetaMemory bm, RightTupleSets srcRightTuples) {
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static void dpUpdatesExistentialReorderRightMemory(BetaMemory bm, BetaNode betaNode, RightTupleSets srcRightTuples) {
        RightTuple tempRightTuple;
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        boolean resumeFromCurrent = !betaNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                if (resumeFromCurrent && rightTuple.getBlocked() != null) {
                    for (tempRightTuple = (RightTuple)rightTuple.getNext(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getNext()) {
                    }
                    if (tempRightTuple == null) {
                        for (tempRightTuple = (RightTuple)rightTuple.getPrevious(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getPrevious()) {
                        }
                    }
                    rightTuple.setTempNextRightTuple(tempRightTuple);
                }
                rightTuple.setTempBlocked(rightTuple.getBlocked());
                rightTuple.nullBlocked();
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                if (resumeFromCurrent) {
                    tempRightTuple = rightTuple.getTempNextRightTuple();
                    if (rightTuple.getBlocked() != null && tempRightTuple == null && rightTuple.getMemory() == rightTuple.getTempRightTupleMemory()) {
                        rightTuple.setTempNextRightTuple(rightTuple);
                    }
                }
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static boolean useLeftMemory(LeftTupleSource tupleSource, LeftTuple leftTuple) {
        Object object;
        boolean useLeftMemory = true;
        if (!(tupleSource.isLeftTupleMemoryEnabled() || (object = leftTuple.getRootLeftTuple().getLastHandle().getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        return useLeftMemory;
    }
}

