/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ShadowProxy;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPoint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPointNode
extends ObjectSource
implements Externalizable,
ObjectSink {
    private static final long serialVersionUID = 510L;
    protected static transient Logger log = LoggerFactory.getLogger(EntryPointNode.class);
    private EntryPoint entryPoint;
    private Map<ObjectType, ObjectTypeNode> objectTypeNodes;
    private ObjectTypeNode queryNode;
    private ObjectTypeNode activationNode;
    private boolean unlinkingEnabled;

    public EntryPointNode() {
    }

    public EntryPointNode(int id, ObjectSource objectSource, BuildContext context) {
        this(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getCurrentEntryPoint());
    }

    public EntryPointNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, EntryPoint entryPoint) {
        super(id, partitionId, partitionsEnabled, objectSource, 999);
        this.entryPoint = entryPoint;
        this.objectTypeNodes = new ConcurrentHashMap<ObjectType, ObjectTypeNode>();
        this.unlinkingEnabled = ((Rete)objectSource).getRuleBase().getConfiguration().isPhreakEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.entryPoint = (EntryPoint)in.readObject();
        this.objectTypeNodes = (Map)in.readObject();
        this.unlinkingEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.entryPoint);
        out.writeObject(this.objectTypeNodes);
        out.writeBoolean(this.unlinkingEnabled);
    }

    @Override
    public short getType() {
        return 10;
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void assertQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        if (this.queryNode != null) {
            this.queryNode.assertObject(factHandle, context, workingMemory);
        }
    }

    public void retractQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        if (this.queryNode != null) {
            this.queryNode.retractObject(factHandle, context, workingMemory);
        }
    }

    public void modifyQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        if (this.queryNode != null) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(factHandle.getFirstLeftTuple(), factHandle.getFirstRightTuple(), this.unlinkingEnabled);
            factHandle.clearLeftTuples();
            factHandle.clearRightTuples();
            this.queryNode.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            modifyPreviousTuples.retractTuples(context, workingMemory);
        }
    }

    public ObjectTypeNode getQueryNode() {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        return this.queryNode;
    }

    public void assertActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.assertObject(factHandle, context, workingMemory);
        }
    }

    public void retractActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.retractObject(factHandle, context, workingMemory);
        }
    }

    public void modifyActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(factHandle.getFirstLeftTuple(), factHandle.getFirstRightTuple(), this.unlinkingEnabled);
            factHandle.clearLeftTuples();
            factHandle.clearRightTuples();
            this.activationNode.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            modifyPreviousTuples.retractTuples(context, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        if (log.isTraceEnabled()) {
            log.trace("Insert {}", (Object)handle.toString());
        }
        if (objectTypeConf.isShadowEnabled()) {
            ((ShadowProxy)handle.getObject()).updateProxy();
        }
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        int length = cachedNodes.length;
        for (int i = 0; i < length; ++i) {
            cachedNodes[i].assertObject(handle, context, workingMemory);
        }
    }

    public void modifyObject(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("Update {}", (Object)handle.toString());
        }
        if (objectTypeConf.isShadowEnabled()) {
            ((ShadowProxy)handle.getObject()).updateProxy();
        }
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(handle.getFirstLeftTuple(), handle.getFirstRightTuple(), this.unlinkingEnabled);
        handle.clearLeftTuples();
        handle.clearRightTuples();
        int length = cachedNodes.length;
        block0: for (int i = 0; i < length; ++i) {
            cachedNodes[i].modifyObject(handle, modifyPreviousTuples, pctx, wm);
            if (i >= cachedNodes.length - 1) continue;
            RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
            while (rightTuple != null && ((BetaNode)rightTuple.getRightTupleSink()).getObjectTypeNode() == cachedNodes[i]) {
                modifyPreviousTuples.removeRightTuple();
                if (this.unlinkingEnabled) {
                    rightTuple.setPropagationContext(pctx);
                    BetaMemory bm = BetaNode.getBetaMemory((BetaNode)rightTuple.getRightTupleSink(), wm);
                    BetaNode.doDeleteRightTuple(rightTuple, (BetaNode)rightTuple.getRightTupleSink(), wm, bm);
                } else {
                    ((BetaNode)rightTuple.getRightTupleSink()).retractRightTuple(rightTuple, pctx, wm);
                }
                rightTuple = modifyPreviousTuples.peekRightTuple();
            }
            while (true) {
                LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple();
                ObjectTypeNode otn = null;
                if (leftTuple != null) {
                    LeftTupleSink leftTupleSink = leftTuple.getLeftTupleSink();
                    if (leftTupleSink instanceof LeftTupleSource) {
                        otn = ((LeftTupleSource)((Object)leftTupleSink)).getLeftTupleSource().getObjectTypeNode();
                    } else if (leftTupleSink instanceof RuleTerminalNode) {
                        otn = ((RuleTerminalNode)leftTupleSink).getObjectTypeNode();
                    }
                }
                if (otn == null || otn == cachedNodes[i + 1]) continue block0;
                modifyPreviousTuples.removeLeftTuple();
                if (this.unlinkingEnabled) {
                    LeftInputAdapterNode liaNode = (LeftInputAdapterNode)leftTuple.getLeftTupleSink().getLeftTupleSource();
                    LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory(liaNode);
                    LeftInputAdapterNode.doDeleteObject(leftTuple, pctx, lm.getSegmentMemory(), wm, liaNode, true, lm);
                    continue;
                }
                leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, pctx, wm);
            }
        }
        modifyPreviousTuples.retractTuples(pctx, wm);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        ObjectTypeNode[] cachedNodes;
        if (log.isTraceEnabled()) {
            log.trace("Delete {}", (Object)handle.toString());
        }
        if ((cachedNodes = objectTypeConf.getObjectTypeNodes()) == null) {
            return;
        }
        for (int i = 0; i < cachedNodes.length; ++i) {
            cachedNodes[i].retractObject(handle, context, workingMemory);
        }
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    @Override
    protected void removeObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.remove(node.getObjectType());
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            workingMemory.updateEntryPointsCache();
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
    }

    public Map<ObjectType, ObjectTypeNode> getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    @Override
    public int hashCode() {
        return this.entryPoint.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EntryPointNode)) {
            return false;
        }
        EntryPointNode other = (EntryPointNode)object;
        return this.entryPoint.equals(other.entryPoint);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode node = (ObjectTypeNode)sink;
        ObjectType newObjectType = node.getObjectType();
        InternalWorkingMemoryEntryPoint wmEntryPoint = (InternalWorkingMemoryEntryPoint)((Object)workingMemory.getWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId()));
        for (ObjectTypeConf objectTypeConf : wmEntryPoint.getObjectTypeConfigurationRegistry().values()) {
            if (!newObjectType.isAssignableFrom(objectTypeConf.getConcreteObjectTypeNode().getObjectType())) continue;
            objectTypeConf.resetCache();
            ObjectTypeNode sourceNode = objectTypeConf.getConcreteObjectTypeNode();
            Iterator it = ((ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)sourceNode)).memory.iterator();
            ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
            while (entry != null) {
                sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
                entry = (ObjectHashSet.ObjectEntry)it.next();
            }
        }
    }

    public boolean isObjectMemoryEnabled() {
        return false;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        throw new UnsupportedOperationException("Entry Point Node has no Object memory");
    }

    @Override
    public String toString() {
        return "[EntryPointNode(" + this.id + ") " + this.entryPoint + " ]";
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }
}

