/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRanges;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.value.CompositePlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.FromEntityPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.FromSolutionPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.PlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.UndefinedPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningValueSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.solution.Solution;

public class PlanningVariableDescriptor {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private final PropertyAccessor variablePropertyAccessor;
    private boolean chained;
    private PlanningValueRangeDescriptor valueRangeDescriptor;
    private boolean nullable;
    private SelectionFilter reinitializeVariableEntityFilter;
    private PlanningValueSorter valueSorter;

    public PlanningVariableDescriptor(PlanningEntityDescriptor planningEntityDescriptor, PropertyDescriptor propertyDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
        this.variablePropertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
    }

    public void processAnnotations() {
        this.processPropertyAnnotations();
    }

    private void processPropertyAnnotations() {
        PlanningVariable planningVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(PlanningVariable.class);
        this.valueSorter = new PlanningValueSorter();
        this.processNullable(planningVariableAnnotation);
        this.processStrength(planningVariableAnnotation);
        this.processChained(planningVariableAnnotation);
        this.processValueRangeAnnotation();
    }

    private void processNullable(PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variablePropertyAccessor.getPropertyType().isPrimitive()) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variablePropertyAccessor.getPropertyType() + ").");
        }
        Class<? extends SelectionFilter> reinitializeVariableEntityFilterClass = planningVariableAnnotation.reinitializeVariableEntityFilter();
        if (reinitializeVariableEntityFilterClass == PlanningVariable.NullReinitializeVariableEntityFilter.class) {
            reinitializeVariableEntityFilterClass = null;
        }
        this.reinitializeVariableEntityFilter = reinitializeVariableEntityFilterClass != null ? ConfigUtils.newInstance(this, "reinitializeVariableEntityFilterClass", reinitializeVariableEntityFilterClass) : new NullValueReinitializeVariableEntityFilter(this);
    }

    private void processStrength(PlanningVariable planningVariableAnnotation) {
        Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass;
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") property (" + this.variablePropertyAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this, "strengthComparatorClass", strengthComparatorClass);
            this.valueSorter.setStrengthComparator(strengthComparator);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.valueSorter.setStrengthWeightFactory(strengthWeightFactory);
        }
    }

    private void processChained(PlanningVariable planningVariableAnnotation) {
        this.chained = planningVariableAnnotation.chained();
        if (this.chained && !this.variablePropertyAccessor.getPropertyType().isAssignableFrom(this.planningEntityDescriptor.getPlanningEntityClass())) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.variablePropertyAccessor.getPropertyType() + ") which is not a superclass/interface of or the same as the planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ").");
        }
        if (this.chained && this.nullable) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    private void processValueRangeAnnotation() {
        Method propertyGetter = this.variablePropertyAccessor.getReadMethod();
        ValueRange valueRangeAnnotation = propertyGetter.getAnnotation(ValueRange.class);
        ValueRanges valueRangesAnnotation = propertyGetter.getAnnotation(ValueRanges.class);
        if (valueRangeAnnotation != null) {
            if (valueRangesAnnotation != null) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") that has a @ValueRange and @ValueRanges annotation: fold them into 1 @ValueRanges.");
            }
            this.valueRangeDescriptor = this.buildValueRangeDescriptor(valueRangeAnnotation);
        } else {
            if (valueRangesAnnotation == null) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") that has no @ValueRange or @ValueRanges annotation.");
            }
            ArrayList<PlanningValueRangeDescriptor> valueRangeDescriptorList = new ArrayList<PlanningValueRangeDescriptor>(valueRangesAnnotation.value().length);
            for (ValueRange partialValueRangeAnnotation : valueRangesAnnotation.value()) {
                valueRangeDescriptorList.add(this.buildValueRangeDescriptor(partialValueRangeAnnotation));
            }
            this.valueRangeDescriptor = new CompositePlanningValueRangeDescriptor(this, valueRangeDescriptorList);
        }
    }

    private PlanningValueRangeDescriptor buildValueRangeDescriptor(ValueRange valueRangeAnnotation) {
        switch (valueRangeAnnotation.type()) {
            case FROM_SOLUTION_PROPERTY: {
                return new FromSolutionPropertyPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
            case FROM_PLANNING_ENTITY_PROPERTY: {
                return new FromEntityPropertyPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
            case UNDEFINED: {
                return new UndefinedPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
        }
        throw new IllegalStateException("The valueRangeType (" + (Object)((Object)valueRangeAnnotation.type()) + ") is not implemented.");
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor() {
        return this.planningEntityDescriptor;
    }

    public String getVariableName() {
        return this.variablePropertyAccessor.getName();
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyAccessor.getPropertyType();
    }

    public boolean isContinuous() {
        return false;
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public PlanningValueRangeDescriptor getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public boolean isInitialized(Object entity) {
        if (this.nullable) {
            return true;
        }
        Object variable = this.getValue(entity);
        return variable != null;
    }

    public Object getValue(Object entity) {
        return this.variablePropertyAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variablePropertyAccessor.executeSetter(entity, value);
    }

    public Collection<?> extractAllPlanningValues(Solution solution) {
        return this.valueRangeDescriptor.extractAllValuesWithFiltering(solution);
    }

    public Collection<?> extractPlanningValues(Solution solution, Object entity) {
        return this.valueRangeDescriptor.extractValuesWithFiltering(solution, entity);
    }

    @Deprecated
    public boolean isPlanningValuesCacheable() {
        return this.valueRangeDescriptor.isValuesCacheable();
    }

    @Deprecated
    public PlanningValueSorter getValueSorter() {
        return this.valueSorter;
    }

    public long getValueCount(Solution solution, Object entity) {
        return this.valueRangeDescriptor.getValueCount(solution, entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyAccessor.getName() + " of " + this.planningEntityDescriptor.getPlanningEntityClass().getName() + ")";
    }
}

