/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common;

import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class SelectionCacheLifecycleBridge
implements SolverPhaseLifecycleListener {
    protected final SelectionCacheType cacheType;
    protected final SelectionCacheLifecycleListener selectionCacheLifecycleListener;

    public SelectionCacheLifecycleBridge(SelectionCacheType cacheType, SelectionCacheLifecycleListener selectionCacheLifecycleListener) {
        this.cacheType = cacheType;
        this.selectionCacheLifecycleListener = selectionCacheLifecycleListener;
        if (cacheType == null) {
            throw new IllegalArgumentException("The cacheType (" + (Object)((Object)cacheType) + ") for selectionCacheLifecycleListener (" + selectionCacheLifecycleListener + ") should have already been resolved.");
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.constructCache(solverScope);
        }
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.constructCache(phaseScope.getSolverScope());
        }
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.constructCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.disposeCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.disposeCache(phaseScope.getSolverScope());
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.disposeCache(solverScope);
        }
    }

    public String toString() {
        return "Bridge(" + this.selectionCacheLifecycleListener + ")";
    }
}

