/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.calculatecount.CalculateCountProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.improvingsteppercentage.ImprovingStepPercentageProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreProblemStatistic;

public enum ProblemStatisticType implements StatisticType
{
    BEST_SCORE,
    STEP_SCORE,
    CALCULATE_COUNT_PER_SECOND,
    BEST_SOLUTION_MUTATION,
    IMPROVING_STEP_PERCENTAGE,
    MEMORY_USE;


    public ProblemStatistic create(ProblemBenchmark problemBenchmark) {
        switch (this) {
            case BEST_SCORE: {
                return new BestScoreProblemStatistic(problemBenchmark);
            }
            case STEP_SCORE: {
                return new StepScoreProblemStatistic(problemBenchmark);
            }
            case CALCULATE_COUNT_PER_SECOND: {
                return new CalculateCountProblemStatistic(problemBenchmark);
            }
            case BEST_SOLUTION_MUTATION: {
                return new BestSolutionMutationProblemStatistic(problemBenchmark);
            }
            case IMPROVING_STEP_PERCENTAGE: {
                return new ImprovingStepPercentageProblemStatistic(problemBenchmark);
            }
            case MEMORY_USE: {
                return new MemoryUseProblemStatistic(problemBenchmark);
            }
        }
        throw new IllegalStateException("The problemStatisticType (" + this + ") is not implemented.");
    }
}

