/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.config.constructionheuristic.placer.entity.EntityPlacerConfig;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.DefaultConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.DefaultGreedyFitSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.ConstructionHeuristicPickEarlyType;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.DefaultGreedyDecider;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.forager.GreedyForager;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.optaplanner.core.impl.constructionheuristic.placer.entity.EntityPlacer;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.PlanningEntitySelectionOrder;
import org.optaplanner.core.impl.heuristic.selector.entity.PlanningEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelector;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueWalker;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningVariableWalker;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.termination.Termination;

@XStreamAlias(value="constructionHeuristic")
public class ConstructionHeuristicSolverPhaseConfig
extends SolverPhaseConfig {
    protected ConstructionHeuristicType constructionHeuristicType = null;
    protected ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType = null;
    @XStreamImplicit
    protected List<EntityPlacerConfig> entityPlacerConfigList = null;

    public ConstructionHeuristicType getConstructionHeuristicType() {
        return this.constructionHeuristicType;
    }

    public void setConstructionHeuristicType(ConstructionHeuristicType constructionHeuristicType) {
        this.constructionHeuristicType = constructionHeuristicType;
    }

    public ConstructionHeuristicPickEarlyType getConstructionHeuristicPickEarlyType() {
        return this.constructionHeuristicPickEarlyType;
    }

    public void setConstructionHeuristicPickEarlyType(ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType) {
        this.constructionHeuristicPickEarlyType = constructionHeuristicPickEarlyType;
    }

    public List<EntityPlacerConfig> getEntityPlacerConfigList() {
        return this.entityPlacerConfigList;
    }

    public void setEntityPlacerConfigList(List<EntityPlacerConfig> entityPlacerConfigList) {
        this.entityPlacerConfigList = entityPlacerConfigList;
    }

    @Override
    public ConstructionHeuristicSolverPhase buildSolverPhase(int phaseIndex, EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        if (this.constructionHeuristicType != null) {
            DefaultGreedyFitSolverPhase greedySolverPhase = new DefaultGreedyFitSolverPhase();
            this.configureSolverPhase(greedySolverPhase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
            greedySolverPhase.setGreedyPlanningEntitySelector(this.buildGreedyPlanningEntitySelector(solutionDescriptor));
            greedySolverPhase.setGreedyDecider(this.buildGreedyDecider(solutionDescriptor, environmentMode));
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                greedySolverPhase.setAssertStepScoreFromScratch(true);
            }
            if (environmentMode.isIntrusiveFastAsserted()) {
                greedySolverPhase.setAssertExpectedStepScore(true);
            }
            return greedySolverPhase;
        }
        if (!CollectionUtils.isEmpty(this.entityPlacerConfigList)) {
            if (this.constructionHeuristicPickEarlyType != null) {
                throw new UnsupportedOperationException();
            }
            DefaultConstructionHeuristicSolverPhase phase = new DefaultConstructionHeuristicSolverPhase();
            this.configureSolverPhase(phase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
            if (this.entityPlacerConfigList.size() != 1) {
                throw new IllegalArgumentException("The entityPlacerConfigList (" + this.entityPlacerConfigList + ") must be a singleton or empty. Use multiple " + ConstructionHeuristicSolverPhaseConfig.class + " elements to initialize multiple entity classes.");
            }
            EntityPlacer entityPlacer = this.entityPlacerConfigList.get(0).buildEntityPlacer(environmentMode, solutionDescriptor, phase.getTermination());
            phase.setEntityPlacer(entityPlacer);
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                phase.setAssertStepScoreFromScratch(true);
            }
            if (environmentMode.isIntrusiveFastAsserted()) {
                phase.setAssertExpectedStepScore(true);
            }
            return phase;
        }
        throw new IllegalArgumentException("A constructionHeuristic requires configuration, for example a constructionHeuristicType.");
    }

    @Deprecated
    private GreedyPlanningEntitySelector buildGreedyPlanningEntitySelector(SolutionDescriptor solutionDescriptor) {
        GreedyPlanningEntitySelector greedyPlanningEntitySelector = new GreedyPlanningEntitySelector();
        Collection<PlanningEntityDescriptor> entityDescriptors = solutionDescriptor.getGenuineEntityDescriptors();
        if (entityDescriptors.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityClass.");
        }
        PlanningEntityDescriptor entityDescriptor = entityDescriptors.iterator().next();
        ArrayList<PlanningEntitySelector> planningEntitySelectorList = new ArrayList<PlanningEntitySelector>(1);
        PlanningEntitySelector planningEntitySelector = new PlanningEntitySelector(entityDescriptor);
        planningEntitySelector.setSelectionOrder(this.determinePlanningEntitySelectionOrder());
        planningEntitySelectorList.add(planningEntitySelector);
        greedyPlanningEntitySelector.setPlanningEntitySelectorList(planningEntitySelectorList);
        return greedyPlanningEntitySelector;
    }

    @Deprecated
    private GreedyDecider buildGreedyDecider(SolutionDescriptor solutionDescriptor, EnvironmentMode environmentMode) {
        DefaultGreedyDecider greedyDecider = new DefaultGreedyDecider();
        Collection<PlanningEntityDescriptor> entityDescriptors = solutionDescriptor.getGenuineEntityDescriptors();
        if (entityDescriptors.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityClass.");
        }
        PlanningEntityDescriptor entityDescriptor = entityDescriptors.iterator().next();
        PlanningVariableWalker planningVariableWalker = new PlanningVariableWalker(entityDescriptor);
        ArrayList<PlanningValueWalker> planningValueWalkerList = new ArrayList<PlanningValueWalker>();
        for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getVariableDescriptors()) {
            PlanningValueSelector planningValueSelector = new PlanningValueSelector(variableDescriptor);
            planningValueSelector.setSelectionOrder(this.determinePlanningValueSelectionOrder());
            PlanningValueWalker planningValueWalker = new PlanningValueWalker(variableDescriptor, planningValueSelector);
            planningValueWalkerList.add(planningValueWalker);
        }
        planningVariableWalker.setPlanningValueWalkerList(planningValueWalkerList);
        greedyDecider.setPlanningVariableWalker(planningVariableWalker);
        greedyDecider.setForager(this.buildGreedyForager());
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            greedyDecider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            greedyDecider.setAssertExpectedUndoMoveScore(true);
        }
        return greedyDecider;
    }

    @Deprecated
    private GreedyForager buildGreedyForager() {
        GreedyForager forager = new GreedyForager();
        ConstructionHeuristicPickEarlyType pickEarlyType = this.constructionHeuristicPickEarlyType == null ? ConstructionHeuristicPickEarlyType.NEVER : this.constructionHeuristicPickEarlyType;
        forager.setPickEarlyType(pickEarlyType);
        return forager;
    }

    private PlanningEntitySelectionOrder determinePlanningEntitySelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case BEST_FIT: {
                return PlanningEntitySelectionOrder.ORIGINAL;
            }
            case FIRST_FIT_DECREASING: 
            case BEST_FIT_DECREASING: {
                return PlanningEntitySelectionOrder.DECREASING_DIFFICULTY;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented.");
    }

    private PlanningValueSelectionOrder determinePlanningValueSelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.ORIGINAL;
            }
            case BEST_FIT: 
            case BEST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.INCREASING_STRENGTH;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented.");
    }

    public void inherit(ConstructionHeuristicSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.constructionHeuristicType == null) {
            this.constructionHeuristicType = inheritedConfig.getConstructionHeuristicType();
        }
        if (this.constructionHeuristicPickEarlyType == null) {
            this.constructionHeuristicPickEarlyType = inheritedConfig.getConstructionHeuristicPickEarlyType();
        }
        this.entityPlacerConfigList = ConfigUtils.inheritMergeableListProperty(this.entityPlacerConfigList, inheritedConfig.getEntityPlacerConfigList());
    }

    public static enum ConstructionHeuristicType {
        FIRST_FIT,
        FIRST_FIT_DECREASING,
        BEST_FIT,
        BEST_FIT_DECREASING;

    }
}

