/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity.pillar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.SameValuePillarSelector;

@XStreamAlias(value="pillarSelector")
public class PillarSelectorConfig
extends SelectorConfig {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public PillarSelector buildPillarSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the pillars change every step.");
        }
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, SelectionOrder.ORIGINAL);
        Collection<PlanningVariableDescriptor> variableDescriptors = entitySelector.getEntityDescriptor().getVariableDescriptors();
        return new SameValuePillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder.toRandomSelectionBoolean());
    }

    public void inherit(PillarSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ")";
    }
}

