/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.bruteforce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.impl.bruteforce.event.BruteForceSolverPhaseLifecycleListener;
import org.optaplanner.core.impl.bruteforce.scope.BruteForceSolverPhaseScope;
import org.optaplanner.core.impl.bruteforce.scope.BruteForceStepScope;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelector;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueWalker;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningVariableWalker;

public class BruteForceEntityWalker
implements BruteForceSolverPhaseLifecycleListener {
    private SolutionDescriptor solutionDescriptor;
    private List<PlanningVariableWalker> planningVariableWalkerList;

    public BruteForceEntityWalker(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public void phaseStarted(BruteForceSolverPhaseScope phaseScope) {
        List<Object> workingPlanningEntityList = phaseScope.getWorkingEntityList();
        this.planningVariableWalkerList = new ArrayList<PlanningVariableWalker>(workingPlanningEntityList.size());
        for (Object planningEntity : workingPlanningEntityList) {
            PlanningEntityDescriptor entityDescriptor = this.solutionDescriptor.getEntityDescriptor(planningEntity.getClass());
            PlanningVariableWalker planningVariableWalker = new PlanningVariableWalker(entityDescriptor);
            List<PlanningValueWalker> planningValueWalkerList = this.buildPlanningValueWalkerList(entityDescriptor);
            planningVariableWalker.setPlanningValueWalkerList(planningValueWalkerList);
            this.planningVariableWalkerList.add(planningVariableWalker);
            planningVariableWalker.phaseStarted(phaseScope);
            planningVariableWalker.initWalk(planningEntity);
        }
    }

    private List<PlanningValueWalker> buildPlanningValueWalkerList(PlanningEntityDescriptor entityDescriptor) {
        Collection<PlanningVariableDescriptor> variableDescriptors = entityDescriptor.getVariableDescriptors();
        ArrayList<PlanningValueWalker> planningValueWalkerList = new ArrayList<PlanningValueWalker>(variableDescriptors.size());
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            PlanningValueSelector planningValueSelector = new PlanningValueSelector(variableDescriptor);
            planningValueSelector.setSelectionOrder(PlanningValueSelectionOrder.ORIGINAL);
            planningValueSelector.setSelectionPromotion(PlanningValueSelectionPromotion.NONE);
            planningValueSelector.setRoundRobinSelection(false);
            PlanningValueWalker planningValueWalker = new PlanningValueWalker(variableDescriptor, planningValueSelector);
            planningValueWalkerList.add(planningValueWalker);
        }
        return planningValueWalkerList;
    }

    public boolean hasWalk() {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            if (!planningVariableWalker.hasWalk()) continue;
            return true;
        }
        return false;
    }

    public void walk() {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            if (planningVariableWalker.hasWalk()) {
                planningVariableWalker.walk();
                break;
            }
            planningVariableWalker.resetWalk();
        }
    }

    @Override
    public void stepEnded(BruteForceStepScope stepScope) {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            planningVariableWalker.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(BruteForceSolverPhaseScope phaseScope) {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            planningVariableWalker.phaseEnded(phaseScope);
        }
        this.planningVariableWalkerList = null;
    }
}

