/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class FieldAccessingSolutionCloner<SolutionG extends Solution>
implements SolutionCloner<SolutionG> {
    protected final SolutionDescriptor solutionDescriptor;
    protected final Map<Class, Constructor> constructorCache = new HashMap<Class, Constructor>();
    protected final Map<Class, List<Field>> fieldListCache = new HashMap<Class, List<Field>>();

    public FieldAccessingSolutionCloner(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public SolutionG cloneSolution(SolutionG originalSolution) {
        return new FieldAccessingSolutionClonerRun().cloneSolution(originalSolution);
    }

    protected <C> Constructor<C> retrieveCachedConstructor(Class<C> clazz) throws NoSuchMethodException {
        Constructor<C> constructor = this.constructorCache.get(clazz);
        if (constructor == null) {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.constructorCache.put(clazz, constructor);
        }
        return constructor;
    }

    protected <C> List<Field> retrieveCachedFields(Class<C> clazz) {
        List<Field> fieldList = this.fieldListCache.get(clazz);
        if (fieldList == null) {
            Field[] fields = clazz.getDeclaredFields();
            fieldList = new ArrayList<Field>(fields.length);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldList.add(field);
            }
            this.fieldListCache.put(clazz, fieldList);
        }
        return fieldList;
    }

    protected static class Unprocessed {
        protected Object bean;
        protected Field field;
        protected Object originalValue;

        public Unprocessed(Object bean, Field field, Object originalValue) {
            this.bean = bean;
            this.field = field;
            this.originalValue = originalValue;
        }
    }

    protected class FieldAccessingSolutionClonerRun {
        protected Map<Object, Object> originalToCloneMap;
        protected Queue<Unprocessed> unprocessedQueue;

        protected FieldAccessingSolutionClonerRun() {
        }

        protected SolutionG cloneSolution(SolutionG originalSolution) {
            this.unprocessedQueue = new LinkedList<Unprocessed>();
            this.originalToCloneMap = new IdentityHashMap<Object, Object>(FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCount((Solution)originalSolution) + 1);
            Solution cloneSolution = (Solution)this.clone(originalSolution);
            this.processQueue();
            this.validateCloneSolution(originalSolution, cloneSolution);
            return cloneSolution;
        }

        protected <C> C clone(C original) {
            if (original == null) {
                return null;
            }
            Object existingClone = this.originalToCloneMap.get(original);
            if (existingClone != null) {
                return (C)existingClone;
            }
            Class<?> clazz = original.getClass();
            Object clone = this.constructClone(clazz);
            this.originalToCloneMap.put(original, clone);
            this.copyFields(clazz, original, clone);
            return (C)clone;
        }

        protected <C> C constructClone(Class<C> clazz) {
            try {
                Constructor<C> constructor = FieldAccessingSolutionCloner.this.retrieveCachedConstructor(clazz);
                return constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
        }

        protected <C> void copyFields(Class<C> clazz, C original, C clone) {
            for (Field field : FieldAccessingSolutionCloner.this.retrieveCachedFields(clazz)) {
                Object originalValue;
                if (this.isDeepCloneField(field, originalValue = this.getFieldValue(original, field))) {
                    this.unprocessedQueue.add(new Unprocessed(clone, field, originalValue));
                    continue;
                }
                this.setFieldValue(clone, field, originalValue);
            }
            Class<C> superclass = clazz.getSuperclass();
            if (superclass != null) {
                this.copyFields(superclass, original, clone);
            }
        }

        protected boolean isDeepCloneField(Field field, Object originalValue) {
            if (originalValue == null) {
                return false;
            }
            if (this.isFieldAnEntityPropertyOnSolution(field)) {
                return true;
            }
            return this.isValueAnEntityOrSolution(originalValue);
        }

        protected boolean isFieldAnEntityPropertyOnSolution(Field field) {
            Class<?> declaringClass = field.getDeclaringClass();
            if (declaringClass == FieldAccessingSolutionCloner.this.solutionDescriptor.getSolutionClass()) {
                String fieldName = field.getName();
                if (FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityPropertyAccessorMap().get(fieldName) != null) {
                    return true;
                }
                if (FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCollectionPropertyAccessorMap().get(fieldName) != null) {
                    return true;
                }
            }
            return false;
        }

        protected boolean isValueAnEntityOrSolution(Object originalValue) {
            Class<?> valueClass = originalValue.getClass();
            return FieldAccessingSolutionCloner.this.solutionDescriptor.hasEntityDescriptor(valueClass) || valueClass == FieldAccessingSolutionCloner.this.solutionDescriptor.getSolutionClass();
        }

        protected void processQueue() {
            while (!this.unprocessedQueue.isEmpty()) {
                Unprocessed unprocessed = this.unprocessedQueue.remove();
                this.process(unprocessed);
            }
        }

        protected void process(Unprocessed unprocessed) {
            Object cloneValue = unprocessed.originalValue instanceof Collection ? this.cloneCollection(unprocessed.field.getType(), (Collection)unprocessed.originalValue) : (unprocessed.originalValue instanceof Map ? this.cloneMap(unprocessed.field.getType(), (Map)unprocessed.originalValue) : this.clone(unprocessed.originalValue));
            this.setFieldValue(unprocessed.bean, unprocessed.field, cloneValue);
        }

        protected <E> Collection<E> cloneCollection(Class<?> expectedType, Collection<E> originalCollection) {
            Collection<E> cloneCollection = this.constructCloneCollection(originalCollection);
            if (!expectedType.isInstance(cloneCollection)) {
                throw new IllegalStateException("The cloneCollectionClass (" + cloneCollection.getClass() + ") created for originalCollectionClass (" + originalCollection.getClass() + ") is not assignable to the field's type (" + expectedType + ")." + " Consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (E originalElement : originalCollection) {
                E cloneElement = this.clone(originalElement);
                cloneCollection.add(cloneElement);
            }
            return cloneCollection;
        }

        protected <E> Collection<E> constructCloneCollection(Collection<E> originalCollection) {
            if (originalCollection instanceof List) {
                if (originalCollection instanceof ArrayList) {
                    return new ArrayList(originalCollection.size());
                }
                if (originalCollection instanceof LinkedList) {
                    return new LinkedList();
                }
                return new ArrayList(originalCollection.size());
            }
            if (originalCollection instanceof Set) {
                if (originalCollection instanceof SortedSet) {
                    Comparator setComparator = ((SortedSet)originalCollection).comparator();
                    return new TreeSet(setComparator);
                }
                if (originalCollection instanceof LinkedHashSet) {
                    return new LinkedHashSet(originalCollection.size());
                }
                if (originalCollection instanceof HashSet) {
                    return new HashSet(originalCollection.size());
                }
                return new LinkedHashSet(originalCollection.size());
            }
            return new ArrayList(originalCollection.size());
        }

        protected <K, V> Map<K, V> cloneMap(Class<?> expectedType, Map<K, V> originalMap) {
            Map<K, V> cloneMap = this.constructCloneMap(originalMap);
            if (!expectedType.isInstance(cloneMap)) {
                throw new IllegalStateException("The cloneMapClass (" + cloneMap.getClass() + ") created for originalMapClass (" + originalMap.getClass() + ") is not assignable to the field's type (" + expectedType + ")." + " Consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (Map.Entry<K, V> originalEntry : originalMap.entrySet()) {
                K cloneKey = this.clone(originalEntry.getKey());
                V cloneValue = this.clone(originalEntry.getValue());
                cloneMap.put(cloneKey, cloneValue);
            }
            return cloneMap;
        }

        protected <K, V> Map<K, V> constructCloneMap(Map<K, V> originalMap) {
            if (originalMap instanceof SortedMap) {
                Comparator setComparator = ((SortedMap)originalMap).comparator();
                return new TreeMap(setComparator);
            }
            if (originalMap instanceof LinkedHashMap) {
                return new LinkedHashMap(originalMap.size());
            }
            if (originalMap instanceof HashMap) {
                return new HashMap(originalMap.size());
            }
            return new LinkedHashMap(originalMap.size());
        }

        protected void validateCloneSolution(SolutionG originalSolution, SolutionG cloneSolution) {
            Object cloneProperty;
            Object originalProperty;
            for (PropertyAccessor propertyAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityPropertyAccessorMap().values()) {
                originalProperty = propertyAccessor.executeGetter(originalSolution);
                if (originalProperty == null || originalProperty != (cloneProperty = propertyAccessor.executeGetter(cloneSolution))) continue;
                throw new IllegalStateException("The solutionProperty (" + propertyAccessor.getName() + ") was not cloned as expected." + " The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize" + " that property's field, probably because its field name is different.");
            }
            for (PropertyAccessor propertyAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCollectionPropertyAccessorMap().values()) {
                originalProperty = propertyAccessor.executeGetter(originalSolution);
                if (originalProperty == null || originalProperty != (cloneProperty = propertyAccessor.executeGetter(cloneSolution))) continue;
                throw new IllegalStateException("The solutionProperty (" + propertyAccessor.getName() + ") was not cloned as expected." + " The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize" + " that property's field, probably because its field name is different.");
            }
        }

        protected Object getFieldValue(Object bean, Field field) {
            try {
                return field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which can not be read to create a clone.", e);
            }
        }

        protected void setFieldValue(Object bean, Field field, Object value) {
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which can not be written with the value (" + value + ") to create a clone.", e);
            }
        }
    }
}

