/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRangeType;
import org.optaplanner.core.impl.domain.value.AbstractPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.FromEntityPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.FromSolutionPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.PlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.value.UndefinedPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class CompositePlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    protected final List<PlanningValueRangeDescriptor> valueRangeDescriptorList;
    protected boolean entityDepentent;

    public CompositePlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, List<PlanningValueRangeDescriptor> valueRangeDescriptorList) {
        super(variableDescriptor);
        this.valueRangeDescriptorList = valueRangeDescriptorList;
        this.entityDepentent = false;
        for (PlanningValueRangeDescriptor valueRangeDescriptor : valueRangeDescriptorList) {
            if (valueRangeDescriptor instanceof UndefinedPlanningValueRangeDescriptor) {
                throw new IllegalArgumentException("The planningEntityClass (" + variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + variableDescriptor.getVariableName() + ") with multiple " + ValueRange.class.getSimpleName() + " annotations," + " including one of type (" + (Object)((Object)ValueRangeType.UNDEFINED) + ").");
            }
            if (valueRangeDescriptor instanceof FromEntityPropertyPlanningValueRangeDescriptor) {
                this.entityDepentent = true;
                continue;
            }
            if (valueRangeDescriptor instanceof FromSolutionPropertyPlanningValueRangeDescriptor) continue;
            throw new IllegalStateException("The valueRangeDescriptorClass (" + valueRangeDescriptor.getClass() + ") is not implemented.");
        }
    }

    @Override
    public boolean isEntityDependent() {
        return this.entityDepentent;
    }

    @Override
    public Collection<?> extractAllValuesWithFiltering(Solution solution) {
        ArrayList values = new ArrayList(0);
        for (PlanningValueRangeDescriptor valueRangeDescriptor : this.valueRangeDescriptorList) {
            values.addAll(valueRangeDescriptor.extractAllValuesWithFiltering(solution));
        }
        return values;
    }

    @Override
    public Collection<?> extractValuesWithFiltering(Solution solution, Object planningEntity) {
        ArrayList values = new ArrayList(0);
        for (PlanningValueRangeDescriptor valueRangeDescriptor : this.valueRangeDescriptorList) {
            values.addAll(valueRangeDescriptor.extractValuesWithFiltering(solution, planningEntity));
        }
        return values;
    }

    @Override
    public long getValueCount(Solution solution, Object planningEntity) {
        long problemScale = 0L;
        for (PlanningValueRangeDescriptor valueRangeDescriptor : this.valueRangeDescriptorList) {
            problemScale += valueRangeDescriptor.getValueCount(solution, planningEntity);
        }
        return problemScale;
    }

    @Override
    public boolean isValuesCacheable() {
        for (PlanningValueRangeDescriptor valueRangeDescriptor : this.valueRangeDescriptorList) {
            if (valueRangeDescriptor.isValuesCacheable()) continue;
            return false;
        }
        return true;
    }
}

