/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch;

import org.optaplanner.core.impl.localsearch.LocalSearchSolverPhase;
import org.optaplanner.core.impl.localsearch.decider.Decider;
import org.optaplanner.core.impl.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultLocalSearchSolverPhase
extends AbstractSolverPhase
implements LocalSearchSolverPhase,
LocalSearchSolverPhaseLifecycleListener {
    protected Decider decider;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;

    public Decider getDecider() {
        return this.decider;
    }

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolverPhase(this);
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
        while (!this.termination.isPhaseTerminated(phaseScope)) {
            stepScope.setTimeGradient(this.termination.calculatePhaseTimeGradient(phaseScope));
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                if (this.termination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("    Step index ({}), time spend ({}) terminated without picking a nextStep.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("    No doable selected move at step index ({}), time spend ({}). Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has accepted/selected move count (" + stepScope.getAcceptedMoveCount() + "/" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + nextStep + ").");
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), nextStep);
            }
            if (this.assertExpectedStepScore) {
                phaseScope.assertExpectedWorkingScore(stepScope.getScore(), nextStep);
            }
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new LocalSearchStepScope(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        if (!phaseScope.getScoreDirector().isWorkingSolutionInitialized()) {
            throw new IllegalStateException("Phase localSearch started with an uninitialized Solution. First initialize the Solution. For example, run a phase constructionHeuristic first.");
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        LocalSearchSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = phaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}), accepted/selected move count ({}/{}) for picked step ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScore(), stepScope.getAcceptedMoveCount(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) localSearch ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

