/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.api.KieBase;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.score.constraint.ConstraintOccurrence;
import org.optaplanner.core.impl.score.constraint.DoubleConstraintOccurrence;
import org.optaplanner.core.impl.score.constraint.IntConstraintOccurrence;
import org.optaplanner.core.impl.score.constraint.LongConstraintOccurrence;
import org.optaplanner.core.impl.score.constraint.UnweightedConstraintOccurrence;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;

public class DroolsScoreDirector
extends AbstractScoreDirector<DroolsScoreDirectorFactory> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected KieSession kieSession;
    protected ScoreHolder workingScoreHolder;

    public DroolsScoreDirector(DroolsScoreDirectorFactory scoreDirectorFactory) {
        super(scoreDirectorFactory);
    }

    protected KieBase getKieBase() {
        return ((DroolsScoreDirectorFactory)this.scoreDirectorFactory).getKieBase();
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetKieSession();
    }

    private void resetKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.kieSession = this.getKieBase().newKieSession();
        this.workingScoreHolder = this.getScoreDefinition().buildScoreHolder(this.constraintMatchEnabledPreference);
        this.kieSession.setGlobal(GLOBAL_SCORE_HOLDER_KEY, (Object)this.workingScoreHolder);
        Collection<Object> workingFacts = this.getWorkingFacts();
        for (Object fact : workingFacts) {
            this.kieSession.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.getSolutionDescriptor().getAllFacts(this.workingSolution);
    }

    @Override
    public Score calculateScore() {
        this.kieSession.fireAllRules();
        Score score = this.workingScoreHolder.extractScore();
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.workingScoreHolder.isConstraintMatchEnabled();
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        return this.workingScoreHolder.getConstraintMatchTotals();
    }

    @Override
    public AbstractScoreDirector clone() {
        return super.clone();
    }

    @Override
    public void dispose() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
        }
    }

    @Override
    public void afterEntityAdded(PlanningEntityDescriptor entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @PlanningEntity.");
        }
        this.kieSession.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(PlanningVariableDescriptor variableDescriptor, Object entity) {
        this.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterShadowVariableChanged(Object entity, String variableName) {
        this.update(entity);
        super.afterShadowVariableChanged(entity, variableName);
    }

    private void update(Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity instance (" + entity + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's entities.");
        }
        this.kieSession.update(factHandle, entity);
    }

    @Override
    public void afterEntityRemoved(PlanningEntityDescriptor entityDescriptor, Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity instance (" + entity + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's entities.");
        }
        this.kieSession.delete(factHandle);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.kieSession.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact instance (" + problemFact + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's getProblemFacts().");
        }
        this.kieSession.update(factHandle, problemFact);
        super.afterProblemFactChanged(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact instance (" + problemFact + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's getProblemFacts().");
        }
        this.kieSession.delete(factHandle);
        super.afterProblemFactRemoved(problemFact);
    }

    @Override
    @Deprecated
    protected void appendLegacyConstraintOccurrences(StringBuilder analysis, ScoreDirector corruptedScoreDirector, ScoreDirector uncorruptedScoreDirector) {
        if (!(uncorruptedScoreDirector instanceof DroolsScoreDirector)) {
            return;
        }
        LinkedHashSet<ConstraintOccurrence> uncorruptedConstraintOccurrenceSet = new LinkedHashSet<ConstraintOccurrence>(((DroolsScoreDirector)uncorruptedScoreDirector).kieSession.getObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class)));
        if (!uncorruptedConstraintOccurrenceSet.isEmpty()) {
            LinkedHashSet<ConstraintOccurrence> corruptedConstraintOccurrenceSet = new LinkedHashSet<ConstraintOccurrence>(((DroolsScoreDirector)corruptedScoreDirector).kieSession.getObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class)));
            if (corruptedConstraintOccurrenceSet.isEmpty()) {
                analysis.append("  Migration analysis: Corrupted ConstraintMatchTotals:\n");
                for (ConstraintMatchTotal constraintMatchTotal : corruptedScoreDirector.getConstraintMatchTotals()) {
                    analysis.append("    ").append(constraintMatchTotal).append("\n");
                }
            } else {
                analysis.append("  Legacy analysis: Corrupted ConstraintOccurrence totals:\n");
                this.appendLegacyTotals(analysis, corruptedConstraintOccurrenceSet);
            }
            analysis.append("  Legacy analysis: Uncorrupted ConstraintOccurrence totals:\n");
            this.appendLegacyTotals(analysis, uncorruptedConstraintOccurrenceSet);
        }
    }

    @Deprecated
    private void appendLegacyTotals(StringBuilder analysis, Set<ConstraintOccurrence> constraintOccurrenceSet) {
        LinkedHashMap<List<Object>, Double> scoreTotalMap = new LinkedHashMap<List<Object>, Double>();
        for (ConstraintOccurrence constraintOccurrence : constraintOccurrenceSet) {
            double occurrenceScore;
            List<Object> key = Arrays.asList(new Object[]{constraintOccurrence.getRuleId(), constraintOccurrence.getConstraintType()});
            Double scoreTotal = (Double)scoreTotalMap.get(key);
            if (scoreTotal == null) {
                scoreTotal = 0.0;
            }
            if (constraintOccurrence instanceof IntConstraintOccurrence) {
                occurrenceScore = ((IntConstraintOccurrence)constraintOccurrence).getWeight();
            } else if (constraintOccurrence instanceof DoubleConstraintOccurrence) {
                occurrenceScore = ((DoubleConstraintOccurrence)constraintOccurrence).getWeight();
            } else if (constraintOccurrence instanceof LongConstraintOccurrence) {
                occurrenceScore = ((LongConstraintOccurrence)constraintOccurrence).getWeight();
            } else if (constraintOccurrence instanceof UnweightedConstraintOccurrence) {
                occurrenceScore = 1.0;
            } else {
                throw new IllegalStateException("Cannot determine occurrenceScore of ConstraintOccurrence class: " + constraintOccurrence.getClass());
            }
            scoreTotal = scoreTotal + occurrenceScore;
            scoreTotalMap.put(key, scoreTotal);
        }
        for (Map.Entry entry : scoreTotalMap.entrySet()) {
            analysis.append("    ").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
    }
}

