/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

public class PeriodChangeMove
implements Move {
    private Lecture lecture;
    private Period toPeriod;

    public PeriodChangeMove(Lecture lecture, Period toPeriod) {
        this.lecture = lecture;
        this.toPeriod = toPeriod;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.lecture.getPeriod(), (Object)this.toPeriod);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new PeriodChangeMove(this.lecture, this.lecture.getPeriod());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        CurriculumCourseMoveHelper.movePeriod(scoreDirector, this.lecture, this.toPeriod);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.lecture);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PeriodChangeMove) {
            PeriodChangeMove other = (PeriodChangeMove)o;
            return new EqualsBuilder().append((Object)this.lecture, (Object)other.lecture).append((Object)this.toPeriod, (Object)other.toPeriod).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lecture).append((Object)this.toPeriod).toHashCode();
    }

    public String toString() {
        return this.lecture + " => " + this.toPeriod;
    }
}

