/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.manners2009.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRangeType;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.manners2009.domain.Guest;
import org.optaplanner.examples.manners2009.domain.Job;
import org.optaplanner.examples.manners2009.domain.JobType;
import org.optaplanner.examples.manners2009.domain.Seat;
import org.optaplanner.examples.manners2009.domain.Table;

@PlanningEntity
@XStreamAlias(value="SeatDesignation")
public class SeatDesignation
extends AbstractPersistable {
    private Guest guest;
    private Seat seat;

    public Guest getGuest() {
        return this.guest;
    }

    public void setGuest(Guest guest) {
        this.guest = guest;
    }

    @PlanningVariable
    @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="seatList")
    public Seat getSeat() {
        return this.seat;
    }

    public void setSeat(Seat seat) {
        this.seat = seat;
    }

    public Job getGuestJob() {
        return this.getGuest().getJob();
    }

    public JobType getGuestJobType() {
        return this.getGuest().getJob().getJobType();
    }

    public Table getSeatTable() {
        if (this.seat == null) {
            return null;
        }
        return this.seat.getTable();
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SeatDesignation) {
            SeatDesignation other = (SeatDesignation)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.guest, (Object)other.guest).append((Object)this.seat, (Object)other.seat).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.guest).append((Object)this.seat).toHashCode();
    }

    @Override
    public String toString() {
        return this.guest + " @ " + this.seat;
    }
}

