/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.IncrementalResultsImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.io.impl.BaseResource;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class KieBuilderSetImpl
implements KieBuilderSet {
    private final KieBuilderImpl kieBuilder;
    private String[] files;
    private List<KnowledgeBuilderError> previousErrors;
    private final Map<String, Set<String>> resourcesWithErrors = new HashMap<String, Set<String>>();

    public KieBuilderSetImpl(KieBuilderImpl kieBuilder) {
        this.kieBuilder = kieBuilder;
        this.registerInitialErrors(kieBuilder);
    }

    private void registerInitialErrors(KieBuilderImpl kieBuilder) {
        this.previousErrors = new ArrayList<KnowledgeBuilderError>();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                this.previousErrors.add(error);
            }
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithErrors(kBuilder));
        }
    }

    KieBuilderSetImpl setFiles(String[] files) {
        this.files = files;
        return this;
    }

    public IncrementalResults build() {
        if (this.files == null) {
            return new IncrementalResultsImpl();
        }
        for (String file : this.files) {
            this.kieBuilder.copySourceToTarget(file);
        }
        return this.buildChanges();
    }

    private Set<String> findResourcesWithErrors(KnowledgeBuilder kBuilder) {
        if (kBuilder.hasErrors()) {
            HashSet<String> resourcesWithErrors = new HashSet<String>();
            for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                resourcesWithErrors.add(error.getResource().getSourcePath());
            }
            return resourcesWithErrors;
        }
        return Collections.emptySet();
    }

    private IncrementalResults buildChanges() {
        ArrayList<KnowledgeBuilderError> currentErrors = new ArrayList<KnowledgeBuilderError>();
        InternalKieModule kieModule = (InternalKieModule)this.kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            CompositeKnowledgeBuilder ckbuilder = kBuilder.batch();
            PackageBuilder pkgBuilder = ((KnowledgeBuilderImpl)kBuilder).getPackageBuilder();
            Set<String> wrongResources = this.resourcesWithErrors.get(kBaseModel.getName());
            for (String resourceName : wrongResources) {
                pkgBuilder.removeObjectsGeneratedFromResource((Resource)new DummyResource(resourceName));
                this.addResource(ckbuilder, kBaseModel, kieModule, resourceName);
            }
            boolean modified = false;
            for (String file : this.files) {
                String resourceName;
                String string = resourceName = file.startsWith(KieBuilderImpl.RESOURCES_ROOT) ? file.substring(KieBuilderImpl.RESOURCES_ROOT.length()) : file;
                if (wrongResources.contains(resourceName)) {
                    modified = true;
                    continue;
                }
                modified = pkgBuilder.removeObjectsGeneratedFromResource((Resource)new DummyResource(resourceName)) || modified;
                modified = this.addResource(ckbuilder, kBaseModel, kieModule, resourceName) || modified;
            }
            if (!modified) continue;
            ckbuilder.build();
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithErrors(kBuilder));
            if (kBuilder.hasErrors()) {
                currentErrors.addAll((Collection<KnowledgeBuilderError>)kBuilder.getErrors());
                kBuilder.undo();
                continue;
            }
            KieServices.Factory.get().getRepository().addKieModule((KieModule)kieModule);
        }
        this.files = null;
        IncrementalResultsImpl results = this.getIncrementalResults(currentErrors);
        this.previousErrors = currentErrors;
        return results;
    }

    private IncrementalResultsImpl getIncrementalResults(List<KnowledgeBuilderError> currentErrors) {
        IncrementalResultsImpl results = new IncrementalResultsImpl();
        for (KnowledgeBuilderError error : currentErrors) {
            if (this.previousErrors.remove(error)) continue;
            results.addMessage((KnowledgeBuilderResult)error);
        }
        for (KnowledgeBuilderError error : this.previousErrors) {
            results.removeMessage((KnowledgeBuilderResult)error);
        }
        return results;
    }

    private boolean addResource(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule, String resourceName) {
        byte[] bytes = kieModule.getBytes(resourceName);
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        Resource resource = KieServices.Factory.get().getResources().newByteArrayResource(bytes).setSourcePath(resourceName);
        if (KieBuilderImpl.filterFileInKBase(kieBaseModel, resourceName)) {
            ResourceConfiguration conf = AbstractKieModule.getResourceConfiguration(kieModule, resourceName);
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName));
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), conf);
            }
            return true;
        }
        return false;
    }

    public static class DummyResource
    extends BaseResource {
        public DummyResource(String resourceName) {
            this.setSourcePath(resourceName);
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getURL -> TODO");
        }

        public boolean hasURL() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.hasURL -> TODO");
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.isDirectory -> TODO");
        }

        public Collection<Resource> listResources() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.listResources -> TODO");
        }

        public long getLastModified() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getLastModified -> TODO");
        }

        public long getLastRead() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getLastRead -> TODO");
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getInputStream -> TODO");
        }

        public Reader getReader() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getReader -> TODO");
        }
    }
}

