/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.RightTupleEntry;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.RightTupleList;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;
    private boolean emptyBetaConstraints;

    public NotNode() {
    }

    public NotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.emptyBetaConstraints = joinNodeBinder.getConstraints().length == 0 || context.isEmptyForAllBetaConstraints();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.emptyBetaConstraints = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.emptyBetaConstraints);
    }

    public boolean isEmptyBetaConstraints() {
        return this.emptyBetaConstraints;
    }

    public void setEmptyBetaConstraints(boolean emptyBetaConstraints) {
        this.emptyBetaConstraints = emptyBetaConstraints;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)it.next(rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        if (leftTuple.getBlocker() == null) {
            if (useLeftMemory) {
                memory.getLeftTupleMemory().add(leftTuple);
            }
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        BetaMemory memory = (BetaMemory)NotNode.getBetaMemoryFromRightInput(this, wm);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        rightTuple.setPropagationContext(pctx);
        if (this.isUnlinkingEnabled()) {
            boolean stagedInsertWasEmpty = false;
            if (this.streamMode) {
                stagedInsertWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
                memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory));
            } else {
                stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
            }
            if (memory.getAndIncCounter() == 0 && this.isEmptyBetaConstraints()) {
                memory.linkNode(wm);
            } else if (stagedInsertWasEmpty) {
                memory.getSegmentMemory().notifyRuleLinkSegment(wm);
            }
            return;
        }
        this.assertRightTuple(rightTuple, pctx, wm);
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, it);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)it.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        rightTuple.setPropagationContext(context);
        if (this.isUnlinkingEnabled()) {
            RightTupleSets stagedRightTuples = memory.getStagedRightTuples();
            boolean stagedDeleteWasEmpty = false;
            if (this.streamMode) {
                stagedDeleteWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
                memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, context, memory));
            } else {
                stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
            }
            if (memory.getAndDecCounter() == 1 && this.isEmptyBetaConstraints()) {
                memory.linkNode(workingMemory);
            } else if (stagedDeleteWasEmpty) {
                memory.getSegmentMemory().notifyRuleLinkSegment(workingMemory);
            }
            return;
        }
        RightTupleMemory rtm = memory.getRightTupleMemory();
        if (rightTuple.getBlocked() != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, memory.getLeftTupleMemory(), rightTuple.getBlocked(), rtm, false);
            rightTuple.nullBlocked();
        } else {
            rtm.remove(rightTuple);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
            memory.getLeftTupleMemory().remove(leftTuple);
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        } else {
            blocker.removeBlocked(leftTuple);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple firstRightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove(leftTuple);
        } else if (rightMemory.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
            }
            RightTuple newBlocker = firstRightTuple;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
            if (leftTuple.getBlocker() != null) {
                if (leftTuple.getFirstChild() != null) {
                    this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
                }
            } else if (leftTuple.getFirstChild() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                this.propagateAssertLeftTuple(context, workingMemory, leftTuple);
            } else {
                memory.getLeftTupleMemory().add(leftTuple);
                this.propagateModifyChildLeftTuple(context, workingMemory, leftTuple);
            }
        }
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().removeAdd(rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple firstLeftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, leftIt);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.nullBlocked();
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove(leftTuple);
                this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
        RightTupleMemory rightTupleMemory = memory.getRightTupleMemory();
        if (firstBlocked != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, leftMemory, firstBlocked, rightTupleMemory, true);
        } else {
            rightTupleMemory.removeAdd(rightTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
    }

    private void updateLeftTupleToNewBlocker(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory, LeftTupleMemory leftMemory, LeftTuple firstBlocked, RightTupleMemory rightTupleMemory, boolean removeAdd) {
        boolean resumeFromCurrent = !this.indexedUnificationJoin && !rightTupleMemory.getIndexType().isComparison();
        FastIterator rightIt = null;
        RightTuple rootBlocker = null;
        if (resumeFromCurrent) {
            RightTupleList currentRtm = rightTuple.getMemory();
            rightIt = currentRtm.fastIterator();
            rootBlocker = (RightTuple)rightTuple.getNext();
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
            if (rootBlocker == null && rightTuple.getMemory() == currentRtm) {
                rootBlocker = rightTuple;
            }
        } else {
            rightIt = this.getRightIterator(rightTupleMemory);
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
        }
        LeftTuple leftTuple = firstBlocked;
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.clearBlocker();
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            if (!resumeFromCurrent) {
                rootBlocker = this.getFirstRightTuple(leftTuple, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
            }
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
            if (leftTuple.getBlocker() == null) {
                leftMemory.add(leftTuple);
                this.propagateAssertLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
    }

    protected void propagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
    }

    protected void propagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
    }

    protected void propagateModifyChildLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            sink.assertLeftTuple(sink.createLeftTuple(leftTuple, sink, context, true), context, workingMemory);
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    @Override
    public short getType() {
        return 191;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        NotNodeLeftTuple peer = new NotNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public String toString() {
        ObjectTypeNode source = this.getObjectTypeNode();
        return "[NotNode(" + this.getId() + ") - " + (source != null ? source.getObjectType() : "<source from a subnetwork>") + "]";
    }
}

