/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRangeType;
import org.optaplanner.core.api.domain.value.ValueRanges;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.solver.LatitudeVisitDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=LatitudeVisitDifficultyComparator.class)
@XStreamAlias(value="Visit")
public class Visit
extends AbstractPersistable
implements Standstill {
    private City city;
    private Standstill previousStandstill;

    @Override
    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    @PlanningVariable(chained=true)
    @ValueRanges(value={@ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="domicileList"), @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="visitList", excludeUninitializedPlanningEntity=true)})
    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    public int getDistanceToPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0;
        }
        return this.getDistanceTo(this.previousStandstill);
    }

    public int getDistanceTo(Standstill standstill) {
        return this.city.getDistance(standstill.getCity());
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Visit) {
            Visit other = (Visit)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.city, (Object)other.city).append((Object)this.previousStandstill, (Object)other.previousStandstill).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.city).append((Object)this.previousStandstill).toHashCode();
    }

    @Override
    public String toString() {
        return this.city + "(after " + (this.previousStandstill == null ? "null" : this.previousStandstill.getCity()) + ")";
    }
}

