/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;

public class ModifyPreviousTuples {
    private LeftTuple leftTuple;
    private RightTuple rightTuple;
    private boolean unlinkingEnabled;

    public ModifyPreviousTuples(LeftTuple leftTuple, RightTuple rightTuple, boolean unlinkingEnabled) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
        this.unlinkingEnabled = unlinkingEnabled;
    }

    public LeftTuple peekLeftTuple() {
        return this.leftTuple;
    }

    public RightTuple peekRightTuple() {
        return this.rightTuple;
    }

    public void removeLeftTuple() {
        LeftTuple current = this.leftTuple;
        current.setLeftParentPrevious(null);
        this.leftTuple = current.getLeftParentNext();
        current.setLeftParentNext(null);
    }

    public void removeRightTuple() {
        RightTuple current = this.rightTuple;
        current.setHandlePrevious(null);
        this.rightTuple = current.getHandleNext();
        current.setHandleNext(null);
    }

    public void retractTuples(PropagationContext pctx, InternalWorkingMemory wm) {
        Entry current;
        if (this.leftTuple != null) {
            for (current = this.leftTuple; current != null; current = current.getLeftParentNext()) {
                if (this.unlinkingEnabled) {
                    LeftInputAdapterNode liaNode = (LeftInputAdapterNode)current.getLeftTupleSink().getLeftTupleSource();
                    if (liaNode == null) continue;
                    LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory(liaNode);
                    LeftInputAdapterNode.doDeleteObject((LeftTuple)current, pctx, lm.getSegmentMemory(), wm, liaNode, true, lm);
                    continue;
                }
                current.getLeftTupleSink().retractLeftTuple((LeftTuple)current, pctx, wm);
            }
        }
        if (this.rightTuple != null) {
            for (current = this.rightTuple; current != null; current = ((RightTuple)current).getHandleNext()) {
                BetaNode node = (BetaNode)((RightTuple)current).getRightTupleSink();
                if (this.unlinkingEnabled) {
                    BetaMemory bm = BetaNode.getBetaMemory(node, wm);
                    ((RightTuple)current).setPropagationContext(pctx);
                    node.doDeleteRightTuple((RightTuple)current, wm, bm);
                    continue;
                }
                node.retractRightTuple((RightTuple)current, pctx, wm);
            }
        }
    }
}

