/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic.placer.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.config.constructionheuristic.placer.PlacerConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.placer.value.ValuePlacer;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.termination.Termination;

@XStreamAlias(value="valuePlacer")
public class ValuePlacerConfig
extends PlacerConfig {
    @XStreamAlias(value="valueSelector")
    protected ValueSelectorConfig valueSelectorConfig = null;
    protected Integer selectedCountLimit = null;

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public Integer getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(Integer selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public ValuePlacer buildValuePlacer(HeuristicConfigPolicy configPolicy, Termination phaseTermination, PlanningEntityDescriptor entityDescriptor) {
        ValueSelectorConfig valueSelectorConfig_ = this.valueSelectorConfig == null ? new ValueSelectorConfig() : this.valueSelectorConfig;
        ValueSelector valueSelector = valueSelectorConfig_.buildValueSelector(configPolicy, entityDescriptor, this.selectedCountLimit == null ? SelectionCacheType.STEP : SelectionCacheType.JUST_IN_TIME, this.selectedCountLimit == null ? SelectionOrder.ORIGINAL : SelectionOrder.RANDOM);
        ValuePlacer valuePlacer = new ValuePlacer(phaseTermination, valueSelector, this.selectedCountLimit == null ? Integer.MAX_VALUE : this.selectedCountLimit);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            valuePlacer.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            valuePlacer.setAssertExpectedUndoMoveScore(true);
        }
        return valuePlacer;
    }

    public void inherit(ValuePlacerConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.valueSelectorConfig == null) {
            this.valueSelectorConfig = inheritedConfig.getValueSelectorConfig();
        } else if (inheritedConfig.getValueSelectorConfig() != null) {
            this.valueSelectorConfig.inherit(inheritedConfig.getValueSelectorConfig());
        }
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelectorConfig + ")";
    }
}

