/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.bestsolution.BestSolutionRecaller;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.phase.SolverPhase;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.termination.Termination;

@XStreamAlias(value="solver")
public class SolverConfig {
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    protected EnvironmentMode environmentMode = null;
    protected Long randomSeed = null;
    protected Class<? extends Solution> solutionClass = null;
    @XStreamImplicit(itemFieldName="planningEntityClass")
    protected List<Class<?>> planningEntityClassList = null;
    @XStreamAlias(value="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig;
    @XStreamImplicit
    protected List<SolverPhaseConfig> solverPhaseConfigList = null;

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public List<Class<?>> getPlanningEntityClassList() {
        return this.planningEntityClassList;
    }

    public void setPlanningEntityClassList(List<Class<?>> planningEntityClassList) {
        this.planningEntityClassList = planningEntityClassList;
    }

    public ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<SolverPhaseConfig> getSolverPhaseConfigList() {
        return this.solverPhaseConfigList;
    }

    public void setSolverPhaseConfigList(List<SolverPhaseConfig> solverPhaseConfigList) {
        this.solverPhaseConfigList = solverPhaseConfigList;
    }

    public Solver buildSolver() {
        EnvironmentMode environmentMode;
        DefaultSolver solver = new DefaultSolver();
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination();
        solver.setBasicPlumbingTermination(basicPlumbingTermination);
        EnvironmentMode environmentMode2 = environmentMode = this.environmentMode == null ? EnvironmentMode.REPRODUCIBLE : this.environmentMode;
        if (this.randomSeed != null) {
            solver.setRandomSeed(this.randomSeed);
        } else if (environmentMode != EnvironmentMode.PRODUCTION) {
            solver.setRandomSeed(0L);
        }
        SolutionDescriptor solutionDescriptor = this.buildSolutionDescriptor();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = this.scoreDirectorFactoryConfig == null ? new ScoreDirectorFactoryConfig() : this.scoreDirectorFactoryConfig;
        ScoreDirectorFactory scoreDirectorFactory = scoreDirectorFactoryConfig_.buildScoreDirectorFactory(environmentMode, solutionDescriptor);
        solver.setScoreDirectorFactory(scoreDirectorFactory);
        ScoreDefinition scoreDefinition = scoreDirectorFactory.getScoreDefinition();
        HeuristicConfigPolicy configPolicy = new HeuristicConfigPolicy(environmentMode, solutionDescriptor, scoreDefinition);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        Termination termination = terminationConfig_.buildTermination(configPolicy, basicPlumbingTermination);
        solver.setTermination(termination);
        BestSolutionRecaller bestSolutionRecaller = this.buildBestSolutionRecaller(environmentMode);
        solver.setBestSolutionRecaller(bestSolutionRecaller);
        if (CollectionUtils.isEmpty(this.solverPhaseConfigList)) {
            throw new IllegalArgumentException("Configure at least 1 phase (for example <localSearch>) in the solver configuration.");
        }
        ArrayList<SolverPhase> solverPhaseList = new ArrayList<SolverPhase>(this.solverPhaseConfigList.size());
        int phaseIndex = 0;
        for (SolverPhaseConfig solverPhaseConfig : this.solverPhaseConfigList) {
            SolverPhase solverPhase = solverPhaseConfig.buildSolverPhase(phaseIndex, configPolicy, termination);
            ((AbstractSolverPhase)solverPhase).setBestSolutionRecaller(bestSolutionRecaller);
            solverPhaseList.add(solverPhase);
            ++phaseIndex;
        }
        solver.setSolverPhaseList(solverPhaseList);
        return solver;
    }

    protected BestSolutionRecaller buildBestSolutionRecaller(EnvironmentMode environmentMode) {
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecaller();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            bestSolutionRecaller.setAssertBestScoreIsUnmodified(true);
        }
        return bestSolutionRecaller;
    }

    protected SolutionDescriptor buildSolutionDescriptor() {
        if (this.solutionClass == null) {
            throw new IllegalArgumentException("Configure a <solutionClass> in the solver configuration.");
        }
        SolutionDescriptor solutionDescriptor = new SolutionDescriptor(this.solutionClass);
        solutionDescriptor.processAnnotations();
        if (CollectionUtils.isEmpty(this.planningEntityClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <planningEntityClass> in the solver configuration.");
        }
        for (Class<?> planningEntityClass : this.planningEntityClassList) {
            PlanningEntityDescriptor entityDescriptor = new PlanningEntityDescriptor(solutionDescriptor, planningEntityClass);
            solutionDescriptor.addPlanningEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations();
        }
        solutionDescriptor.afterAnnotationsProcessed();
        return solutionDescriptor;
    }

    public void inherit(SolverConfig inheritedConfig) {
        if (this.environmentMode == null) {
            this.environmentMode = inheritedConfig.getEnvironmentMode();
        }
        if (this.randomSeed == null) {
            this.randomSeed = inheritedConfig.getRandomSeed();
        }
        if (this.solutionClass == null) {
            this.solutionClass = inheritedConfig.getSolutionClass();
        }
        this.planningEntityClassList = ConfigUtils.inheritMergeableListProperty(this.planningEntityClassList, inheritedConfig.getPlanningEntityClassList());
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = inheritedConfig.getScoreDirectorFactoryConfig();
        } else if (inheritedConfig.getScoreDirectorFactoryConfig() != null) {
            this.scoreDirectorFactoryConfig.inherit(inheritedConfig.getScoreDirectorFactoryConfig());
        }
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
        this.solverPhaseConfigList = ConfigUtils.inheritMergeableListProperty(this.solverPhaseConfigList, inheritedConfig.getSolverPhaseConfigList());
    }
}

