/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.impl.domain.value.PlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;

public abstract class AbstractPlanningValueRangeDescriptor
implements PlanningValueRangeDescriptor {
    protected PlanningVariableDescriptor variableDescriptor;
    protected boolean excludeUninitializedPlanningEntity;

    public AbstractPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
    }

    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    protected void processExcludeUninitializedPlanningEntity(ValueRange valueRangeAnnotation) {
        this.excludeUninitializedPlanningEntity = valueRangeAnnotation.excludeUninitializedPlanningEntity();
        if (this.excludeUninitializedPlanningEntity) {
            Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
            Set<Class<?>> entityClassSet = this.variableDescriptor.getEntityDescriptor().getSolutionDescriptor().getPlanningEntityClassSet();
            boolean assignableFrom = false;
            for (Class<?> entityClass : entityClassSet) {
                if (!variablePropertyType.isAssignableFrom(entityClass)) continue;
                assignableFrom = true;
                break;
            }
            if (!assignableFrom) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") with excludeUninitializedPlanningEntity (true), but there is no planning entity class" + " that extends the variablePropertyType (" + variablePropertyType + ").");
            }
        }
    }

    protected Collection<?> applyFiltering(Collection<?> values) {
        if (!this.excludeUninitializedPlanningEntity) {
            return values;
        }
        ArrayList filteredValues = new ArrayList(values.size());
        for (Object value : values) {
            Class<?> entityClass = this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass();
            if (entityClass.isAssignableFrom(value.getClass()) && !this.variableDescriptor.isInitialized(value)) continue;
            filteredValues.add(value);
        }
        return filteredValues;
    }

    @Override
    public boolean isValuesCacheable() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

