/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.value;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.value.AbstractPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class FromEntityPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private PropertyAccessor rangePropertyAccessor;

    public FromEntityPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, ValueRange valueRangeAnnotation) {
        super(variableDescriptor);
        this.validate(valueRangeAnnotation);
        this.processValueRangeAnnotation(valueRangeAnnotation);
    }

    private void validate(ValueRange valueRangeAnnotation) {
        if (!valueRangeAnnotation.solutionProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with a non-empty solutionProperty (" + valueRangeAnnotation.solutionProperty() + ").");
        }
        if (valueRangeAnnotation.planningEntityProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with an empty planningEntityProperty (" + valueRangeAnnotation.planningEntityProperty() + ").");
        }
    }

    private void processValueRangeAnnotation(ValueRange valueRangeAnnotation) {
        this.processPlanningEntityProperty(valueRangeAnnotation);
        this.processExcludeUninitializedPlanningEntity(valueRangeAnnotation);
    }

    private void processPlanningEntityProperty(ValueRange valueRangeAnnotation) {
        String planningEntityProperty = valueRangeAnnotation.planningEntityProperty();
        PlanningEntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        this.rangePropertyAccessor = new ReflectionPropertyAccessor(entityDescriptor.getPropertyDescriptor(planningEntityProperty));
        if (this.rangePropertyAccessor == null) {
            String exceptionMessage = "The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a planningEntityProperty (" + planningEntityProperty + ") that does not exist.";
            if (planningEntityProperty.length() >= 2 && Character.isUpperCase(planningEntityProperty.charAt(1))) {
                String correctedPlanningEntityProperty = planningEntityProperty.substring(0, 1).toUpperCase() + planningEntityProperty.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedPlanningEntityProperty (" + correctedPlanningEntityProperty + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyAccessor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a planningEntityProperty (" + planningEntityProperty + ") that does not return a Collection.");
        }
    }

    @Override
    public boolean isEntityDependent() {
        return true;
    }

    @Override
    public Collection<?> extractAllValuesWithFiltering(Solution solution) {
        LinkedHashSet valueSet = new LinkedHashSet();
        for (Object entity : this.variableDescriptor.getEntityDescriptor().extractEntities(solution)) {
            valueSet.addAll(this.extractValuesWithFiltering(solution, entity));
        }
        return valueSet;
    }

    @Override
    public Collection<?> extractValuesWithFiltering(Solution solution, Object planningEntity) {
        Collection<Object> values = this.extractValues(planningEntity);
        return this.applyFiltering(values);
    }

    public Collection<Object> extractValues(Object entity) {
        return (Collection)this.rangePropertyAccessor.executeGetter(entity);
    }

    @Override
    public long getValueCount(Solution solution, Object planningEntity) {
        return this.extractValues(planningEntity).size();
    }
}

