/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.value;

import java.util.Collection;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.value.AbstractPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class FromSolutionPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private PropertyAccessor rangePropertyAccessor;

    public FromSolutionPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, ValueRange valueRangeAnnotation) {
        super(variableDescriptor);
        this.validate(valueRangeAnnotation);
        this.processValueRangeAnnotation(valueRangeAnnotation);
    }

    private void validate(ValueRange valueRangeAnnotation) {
        if (valueRangeAnnotation.solutionProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with an empty solutionProperty (" + valueRangeAnnotation.solutionProperty() + ").");
        }
        if (!valueRangeAnnotation.planningEntityProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with a non-empty planningEntityProperty (" + valueRangeAnnotation.planningEntityProperty() + ").");
        }
    }

    private void processValueRangeAnnotation(ValueRange valueRangeAnnotation) {
        this.processSolutionProperty(valueRangeAnnotation);
        this.processExcludeUninitializedPlanningEntity(valueRangeAnnotation);
    }

    private void processSolutionProperty(ValueRange valueRangeAnnotation) {
        String solutionProperty = valueRangeAnnotation.solutionProperty();
        PlanningEntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        this.rangePropertyAccessor = entityDescriptor.getSolutionDescriptor().getPropertyAccessor(solutionProperty);
        if (this.rangePropertyAccessor == null) {
            String exceptionMessage = "The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a solutionClass (" + entityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionProperty + ") that does not exist.";
            if (solutionProperty.length() >= 2 && Character.isUpperCase(solutionProperty.charAt(1))) {
                String correctedSolutionProperty = solutionProperty.substring(0, 1).toUpperCase() + solutionProperty.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedSolutionProperty (" + correctedSolutionProperty + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyAccessor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a solutionClass (" + entityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionProperty + ") that does not return a Collection.");
        }
    }

    @Override
    public boolean isEntityDependent() {
        return false;
    }

    @Override
    public Collection<?> extractAllValuesWithFiltering(Solution solution) {
        Collection<?> values = this.extractValuesWithoutFiltering(solution);
        return this.applyFiltering(values);
    }

    @Override
    public Collection<?> extractValuesWithFiltering(Solution solution, Object planningEntity) {
        return this.extractAllValuesWithFiltering(solution);
    }

    private Collection<?> extractValuesWithoutFiltering(Solution solution) {
        return (Collection)this.rangePropertyAccessor.executeGetter(solution);
    }

    @Override
    public long getValueCount(Solution solution, Object planningEntity) {
        return this.extractValuesWithoutFiltering(solution).size();
    }

    @Override
    public boolean isValuesCacheable() {
        return !this.excludeUninitializedPlanningEntity;
    }
}

