/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.Night;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.domain.Room;

public class PatientAdmissionSchedulePanel
extends SolutionPanel {
    private TimeTablePanel<Night, Bed> timeTablePanel;

    public PatientAdmissionSchedulePanel() {
        this.setLayout(new BorderLayout());
        this.timeTablePanel = new TimeTablePanel();
        this.add(this.timeTablePanel, "Center");
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private PatientAdmissionSchedule getPatientAdmissionSchedule() {
        return (PatientAdmissionSchedule)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.timeTablePanel.reset();
        PatientAdmissionSchedule patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        this.defineGrid(patientAdmissionSchedule);
        this.fillCells(patientAdmissionSchedule);
        this.repaint();
    }

    private void defineGrid(PatientAdmissionSchedule patientAdmissionSchedule) {
        JButton footprint = new JButton("Patient9999");
        footprint.setMargin(new Insets(0, 0, 0, 0));
        int footprintWidth = footprint.getPreferredSize().width;
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2);
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Night night : patientAdmissionSchedule.getNightList()) {
            this.timeTablePanel.defineColumnHeader(night, footprintWidth);
        }
        this.timeTablePanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        this.timeTablePanel.defineRowHeader(null);
        for (Bed bed : patientAdmissionSchedule.getBedList()) {
            this.timeTablePanel.defineRowHeader(bed);
        }
    }

    private void fillCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Department")));
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Room")));
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Bed")));
        this.fillNightCells(patientAdmissionSchedule);
        this.fillBedCells(patientAdmissionSchedule);
        this.fillBedDesignationCells(patientAdmissionSchedule);
    }

    private void fillNightCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        for (Night night : patientAdmissionSchedule.getNightList()) {
            this.timeTablePanel.addColumnHeader(night, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(night.getLabel(), 0)));
        }
    }

    private void fillBedCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, null, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createHeaderPanel(new JLabel("Unassigned")));
        for (Department department : patientAdmissionSchedule.getDepartmentList()) {
            List<Room> roomList = department.getRoomList();
            List<Bed> firstRoomBedList = roomList.get(0).getBedList();
            List<Bed> lastRoomBedList = roomList.get(roomList.size() - 1).getBedList();
            this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, firstRoomBedList.get(0), TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, lastRoomBedList.get(lastRoomBedList.size() - 1), this.createHeaderPanel(new JLabel(department.getLabel())));
            for (Room room : roomList) {
                List<Bed> bedList = room.getBedList();
                this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, bedList.get(0), TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, bedList.get(bedList.size() - 1), this.createHeaderPanel(new JLabel(room.getLabel(), 4)));
                for (Bed bed : bedList) {
                    this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, bed, this.createHeaderPanel(new JLabel(bed.getLabel(), 4)));
                }
            }
        }
    }

    private void fillBedDesignationCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        for (BedDesignation bedDesignation : patientAdmissionSchedule.getBedDesignationList()) {
            JButton button = new JButton(new BedDesignationAction(bedDesignation));
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setBackground(tangoColorFactory.pickColor(bedDesignation));
            AdmissionPart admissionPart = bedDesignation.getAdmissionPart();
            this.timeTablePanel.addCell(admissionPart.getFirstNight(), bedDesignation.getBed(), admissionPart.getLastNight(), bedDesignation.getBed(), button);
        }
    }

    private JPanel createHeaderPanel(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private class BedDesignationAction
    extends AbstractAction {
        private BedDesignation bedDesignation;

        public BedDesignationAction(BedDesignation bedDesignation) {
            super(bedDesignation.getAdmissionPart().getPatient().getName());
            this.bedDesignation = bedDesignation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Bed> bedList = PatientAdmissionSchedulePanel.this.getPatientAdmissionSchedule().getBedList();
            JComboBox<Object> bedListField = new JComboBox<Object>(bedList.toArray());
            bedListField.setSelectedItem(this.bedDesignation.getBed());
            listFieldsPanel.add(bedListField);
            int result = JOptionPane.showConfirmDialog(PatientAdmissionSchedulePanel.this.getRootPane(), listFieldsPanel, "Select bed", 2);
            if (result == 0) {
                Bed toBed = (Bed)bedListField.getSelectedItem();
                PatientAdmissionSchedulePanel.this.solutionBusiness.doChangeMove(this.bedDesignation, "bed", toBed);
                PatientAdmissionSchedulePanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

