/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.localsearch.decider.acceptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.CompositeAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.hillclimbing.HillClimbingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.lateacceptance.LateAcceptanceAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.latesimulatedannealing.LateSimulatedAnnealingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.AbstractTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.EntityTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.MoveTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.SolutionTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.ValueTabuAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.EntityRatioTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.FixedTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.ValueRatioTabuSizeStrategy;

@XStreamAlias(value="acceptor")
public class AcceptorConfig {
    @XStreamImplicit(itemFieldName="acceptorClass")
    private List<Class<? extends Acceptor>> acceptorClassList = null;
    @XStreamImplicit(itemFieldName="acceptorType")
    private List<AcceptorType> acceptorTypeList = null;
    protected Integer entityTabuSize = null;
    protected Double entityTabuRatio = null;
    protected Integer fadingEntityTabuSize = null;
    protected Double fadingEntityTabuRatio = null;
    protected Integer valueTabuSize = null;
    protected Double valueTabuRatio = null;
    protected Integer fadingValueTabuSize = null;
    protected Double fadingValueTabuRatio = null;
    protected Integer moveTabuSize = null;
    protected Integer fadingMoveTabuSize = null;
    protected Integer undoMoveTabuSize = null;
    protected Integer fadingUndoMoveTabuSize = null;
    protected Integer solutionTabuSize = null;
    protected Integer fadingSolutionTabuSize = null;
    protected String simulatedAnnealingStartingTemperature = null;
    protected Double greatDelugeWaterLevelUpperBoundRate = null;
    protected Double greatDelugeWaterRisingRate = null;
    protected Integer lateAcceptanceSize = null;
    protected Integer lateSimulatedAnnealingSize = null;

    public List<Class<? extends Acceptor>> getAcceptorClassList() {
        return this.acceptorClassList;
    }

    public void setAcceptorClassList(List<Class<? extends Acceptor>> acceptorClassList) {
        this.acceptorClassList = acceptorClassList;
    }

    public List<AcceptorType> getAcceptorTypeList() {
        return this.acceptorTypeList;
    }

    public void setAcceptorTypeList(List<AcceptorType> acceptorTypeList) {
        this.acceptorTypeList = acceptorTypeList;
    }

    public Integer getEntityTabuSize() {
        return this.entityTabuSize;
    }

    public void setEntityTabuSize(Integer entityTabuSize) {
        this.entityTabuSize = entityTabuSize;
    }

    public Double getEntityTabuRatio() {
        return this.entityTabuRatio;
    }

    public void setEntityTabuRatio(Double entityTabuRatio) {
        this.entityTabuRatio = entityTabuRatio;
    }

    public Integer getFadingEntityTabuSize() {
        return this.fadingEntityTabuSize;
    }

    public void setFadingEntityTabuSize(Integer fadingEntityTabuSize) {
        this.fadingEntityTabuSize = fadingEntityTabuSize;
    }

    public Double getFadingEntityTabuRatio() {
        return this.fadingEntityTabuRatio;
    }

    public void setFadingEntityTabuRatio(Double fadingEntityTabuRatio) {
        this.fadingEntityTabuRatio = fadingEntityTabuRatio;
    }

    public Integer getValueTabuSize() {
        return this.valueTabuSize;
    }

    public void setValueTabuSize(Integer valueTabuSize) {
        this.valueTabuSize = valueTabuSize;
    }

    public Double getValueTabuRatio() {
        return this.valueTabuRatio;
    }

    public void setValueTabuRatio(Double valueTabuRatio) {
        this.valueTabuRatio = valueTabuRatio;
    }

    public Integer getFadingValueTabuSize() {
        return this.fadingValueTabuSize;
    }

    public void setFadingValueTabuSize(Integer fadingValueTabuSize) {
        this.fadingValueTabuSize = fadingValueTabuSize;
    }

    public Double getFadingValueTabuRatio() {
        return this.fadingValueTabuRatio;
    }

    public void setFadingValueTabuRatio(Double fadingValueTabuRatio) {
        this.fadingValueTabuRatio = fadingValueTabuRatio;
    }

    public Integer getMoveTabuSize() {
        return this.moveTabuSize;
    }

    public void setMoveTabuSize(Integer moveTabuSize) {
        this.moveTabuSize = moveTabuSize;
    }

    public Integer getFadingMoveTabuSize() {
        return this.fadingMoveTabuSize;
    }

    public void setFadingMoveTabuSize(Integer fadingMoveTabuSize) {
        this.fadingMoveTabuSize = fadingMoveTabuSize;
    }

    public Integer getUndoMoveTabuSize() {
        return this.undoMoveTabuSize;
    }

    public void setUndoMoveTabuSize(Integer undoMoveTabuSize) {
        this.undoMoveTabuSize = undoMoveTabuSize;
    }

    public Integer getFadingUndoMoveTabuSize() {
        return this.fadingUndoMoveTabuSize;
    }

    public void setFadingUndoMoveTabuSize(Integer fadingUndoMoveTabuSize) {
        this.fadingUndoMoveTabuSize = fadingUndoMoveTabuSize;
    }

    public Integer getSolutionTabuSize() {
        return this.solutionTabuSize;
    }

    public void setSolutionTabuSize(Integer solutionTabuSize) {
        this.solutionTabuSize = solutionTabuSize;
    }

    public Integer getFadingSolutionTabuSize() {
        return this.fadingSolutionTabuSize;
    }

    public void setFadingSolutionTabuSize(Integer fadingSolutionTabuSize) {
        this.fadingSolutionTabuSize = fadingSolutionTabuSize;
    }

    public String getSimulatedAnnealingStartingTemperature() {
        return this.simulatedAnnealingStartingTemperature;
    }

    public void setSimulatedAnnealingStartingTemperature(String simulatedAnnealingStartingTemperature) {
        this.simulatedAnnealingStartingTemperature = simulatedAnnealingStartingTemperature;
    }

    public Double getGreatDelugeWaterLevelUpperBoundRate() {
        return this.greatDelugeWaterLevelUpperBoundRate;
    }

    public void setGreatDelugeWaterLevelUpperBoundRate(Double greatDelugeWaterLevelUpperBoundRate) {
        this.greatDelugeWaterLevelUpperBoundRate = greatDelugeWaterLevelUpperBoundRate;
    }

    public Double getGreatDelugeWaterRisingRate() {
        return this.greatDelugeWaterRisingRate;
    }

    public void setGreatDelugeWaterRisingRate(Double greatDelugeWaterRisingRate) {
        this.greatDelugeWaterRisingRate = greatDelugeWaterRisingRate;
    }

    public Integer getLateAcceptanceSize() {
        return this.lateAcceptanceSize;
    }

    public void setLateAcceptanceSize(Integer lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    public Integer getLateSimulatedAnnealingSize() {
        return this.lateSimulatedAnnealingSize;
    }

    public void setLateSimulatedAnnealingSize(Integer lateSimulatedAnnealingSize) {
        this.lateSimulatedAnnealingSize = lateSimulatedAnnealingSize;
    }

    public Acceptor buildAcceptor(HeuristicConfigPolicy configPolicy) {
        AbstractAcceptor acceptor;
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        ArrayList<Acceptor> acceptorList = new ArrayList<Acceptor>();
        if (this.acceptorClassList != null) {
            for (Class<? extends Acceptor> acceptorClass : this.acceptorClassList) {
                Acceptor acceptor2 = ConfigUtils.newInstance(this, "acceptorClass", acceptorClass);
                acceptorList.add(acceptor2);
            }
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.HILL_CLIMBING)) {
            acceptor = new HillClimbingAcceptor();
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_ENTITY_TABU) || this.entityTabuSize != null || this.entityTabuRatio != null || this.fadingEntityTabuSize != null || this.fadingEntityTabuRatio != null) {
            acceptor = new EntityTabuAcceptor();
            if (this.entityTabuSize != null) {
                if (this.entityTabuRatio != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both entityTabuSize (" + this.entityTabuSize + ") and entityTabuRatio (" + this.entityTabuRatio + ").");
                }
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.entityTabuSize));
            } else if (this.entityTabuRatio != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new EntityRatioTabuSizeStrategy(this.entityTabuRatio));
            }
            if (this.fadingEntityTabuSize != null) {
                if (this.fadingEntityTabuRatio != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both fadingEntityTabuSize (" + this.fadingEntityTabuSize + ") and fadingEntityTabuRatio (" + this.fadingEntityTabuRatio + ").");
                }
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingEntityTabuSize));
            } else if (this.fadingEntityTabuRatio != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new EntityRatioTabuSizeStrategy(this.fadingEntityTabuRatio));
            }
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                ((AbstractTabuAcceptor)acceptor).setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_VALUE_TABU) || this.valueTabuSize != null || this.valueTabuRatio != null || this.fadingValueTabuSize != null || this.fadingValueTabuRatio != null) {
            acceptor = new ValueTabuAcceptor();
            if (this.valueTabuSize != null) {
                if (this.valueTabuRatio != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both valueTabuSize (" + this.valueTabuSize + ") and valueTabuRatio (" + this.valueTabuRatio + ").");
                }
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.valueTabuSize));
            } else if (this.valueTabuRatio != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new ValueRatioTabuSizeStrategy(this.valueTabuRatio));
            }
            if (this.fadingValueTabuSize != null) {
                if (this.fadingValueTabuRatio != null) {
                    throw new IllegalArgumentException("The acceptor cannot have both fadingValueTabuSize (" + this.fadingValueTabuSize + ") and fadingValueTabuRatio (" + this.fadingValueTabuRatio + ").");
                }
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingValueTabuSize));
            } else if (this.fadingValueTabuRatio != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new ValueRatioTabuSizeStrategy(this.fadingValueTabuRatio));
            }
            if (this.valueTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.valueTabuSize));
            }
            if (this.fadingValueTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingValueTabuSize));
            }
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                ((AbstractTabuAcceptor)acceptor).setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.MOVE_TABU) || this.moveTabuSize != null || this.fadingMoveTabuSize != null) {
            acceptor = new MoveTabuAcceptor();
            ((MoveTabuAcceptor)acceptor).setUseUndoMoveAsTabuMove(false);
            if (this.moveTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.moveTabuSize));
            }
            if (this.fadingMoveTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingMoveTabuSize));
            }
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                ((AbstractTabuAcceptor)acceptor).setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.UNDO_MOVE_TABU) || this.undoMoveTabuSize != null || this.fadingUndoMoveTabuSize != null) {
            acceptor = new MoveTabuAcceptor();
            ((MoveTabuAcceptor)acceptor).setUseUndoMoveAsTabuMove(true);
            if (this.undoMoveTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.undoMoveTabuSize));
            }
            if (this.fadingUndoMoveTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingUndoMoveTabuSize));
            }
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                ((AbstractTabuAcceptor)acceptor).setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SOLUTION_TABU) || this.solutionTabuSize != null || this.fadingSolutionTabuSize != null) {
            acceptor = new SolutionTabuAcceptor();
            if (this.solutionTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setTabuSizeStrategy(new FixedTabuSizeStrategy(this.solutionTabuSize));
            }
            if (this.fadingSolutionTabuSize != null) {
                ((AbstractTabuAcceptor)acceptor).setFadingTabuSizeStrategy(new FixedTabuSizeStrategy(this.fadingSolutionTabuSize));
            }
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                ((AbstractTabuAcceptor)acceptor).setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SIMULATED_ANNEALING) || this.simulatedAnnealingStartingTemperature != null) {
            acceptor = new SimulatedAnnealingAcceptor();
            ((SimulatedAnnealingAcceptor)acceptor).setStartingTemperature(configPolicy.getScoreDefinition().parseScore(this.simulatedAnnealingStartingTemperature));
            acceptorList.add(acceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.GREAT_DELUGE) || this.greatDelugeWaterLevelUpperBoundRate != null || this.greatDelugeWaterRisingRate != null) {
            double waterLevelUpperBoundRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterLevelUpperBoundRate, (Object)1.2);
            double waterRisingRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterRisingRate, (Object)1.0E-7);
            acceptorList.add(new GreatDelugeAcceptor(waterLevelUpperBoundRate, waterRisingRate));
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.LATE_ACCEPTANCE) || this.lateAcceptanceSize != null) {
            LateAcceptanceAcceptor acceptor3 = new LateAcceptanceAcceptor();
            acceptor3.setLateAcceptanceSize(this.lateAcceptanceSize == null ? 1000 : this.lateAcceptanceSize);
            acceptorList.add(acceptor3);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.LATE_SIMULATED_ANNEALING) || this.lateSimulatedAnnealingSize != null) {
            LateSimulatedAnnealingAcceptor acceptor4 = new LateSimulatedAnnealingAcceptor();
            acceptor4.setLateSimulatedAnnealingSize(this.lateSimulatedAnnealingSize == null ? 1000 : this.lateSimulatedAnnealingSize);
            acceptorList.add(acceptor4);
        }
        if (acceptorList.size() == 1) {
            return (Acceptor)acceptorList.get(0);
        }
        if (acceptorList.size() > 1) {
            CompositeAcceptor compositeAcceptor = new CompositeAcceptor();
            compositeAcceptor.setAcceptorList(acceptorList);
            return compositeAcceptor;
        }
        throw new IllegalArgumentException("The acceptor does not specify any acceptorType (" + this.acceptorTypeList + ") or other acceptor property.\n" + "For a good starting values," + " see the docs section \"Which optimization algorithms should I use?\".");
    }

    public void inherit(AcceptorConfig inheritedConfig) {
        this.acceptorClassList = ConfigUtils.inheritMergeableListProperty(this.acceptorClassList, inheritedConfig.getAcceptorClassList());
        if (this.acceptorTypeList == null) {
            this.acceptorTypeList = inheritedConfig.getAcceptorTypeList();
        } else {
            List<AcceptorType> inheritedAcceptorTypeList = inheritedConfig.getAcceptorTypeList();
            if (inheritedAcceptorTypeList != null) {
                for (AcceptorType acceptorType : inheritedAcceptorTypeList) {
                    if (this.acceptorTypeList.contains((Object)acceptorType)) continue;
                    this.acceptorTypeList.add(acceptorType);
                }
            }
        }
        this.entityTabuSize = ConfigUtils.inheritOverwritableProperty(this.entityTabuSize, inheritedConfig.getEntityTabuSize());
        this.entityTabuRatio = ConfigUtils.inheritOverwritableProperty(this.entityTabuRatio, inheritedConfig.getEntityTabuRatio());
        this.fadingEntityTabuSize = ConfigUtils.inheritOverwritableProperty(this.fadingEntityTabuSize, inheritedConfig.getFadingEntityTabuSize());
        this.fadingEntityTabuRatio = ConfigUtils.inheritOverwritableProperty(this.fadingEntityTabuRatio, inheritedConfig.getFadingEntityTabuRatio());
        this.valueTabuSize = ConfigUtils.inheritOverwritableProperty(this.valueTabuSize, inheritedConfig.getValueTabuSize());
        this.valueTabuRatio = ConfigUtils.inheritOverwritableProperty(this.valueTabuRatio, inheritedConfig.getValueTabuRatio());
        this.fadingValueTabuSize = ConfigUtils.inheritOverwritableProperty(this.fadingValueTabuSize, inheritedConfig.getFadingValueTabuSize());
        this.fadingValueTabuRatio = ConfigUtils.inheritOverwritableProperty(this.fadingValueTabuRatio, inheritedConfig.getFadingValueTabuRatio());
        this.moveTabuSize = ConfigUtils.inheritOverwritableProperty(this.moveTabuSize, inheritedConfig.getMoveTabuSize());
        this.fadingMoveTabuSize = ConfigUtils.inheritOverwritableProperty(this.fadingMoveTabuSize, inheritedConfig.getFadingMoveTabuSize());
        this.undoMoveTabuSize = ConfigUtils.inheritOverwritableProperty(this.undoMoveTabuSize, inheritedConfig.getUndoMoveTabuSize());
        this.fadingUndoMoveTabuSize = ConfigUtils.inheritOverwritableProperty(this.fadingUndoMoveTabuSize, inheritedConfig.getFadingUndoMoveTabuSize());
        this.solutionTabuSize = ConfigUtils.inheritOverwritableProperty(this.solutionTabuSize, inheritedConfig.getSolutionTabuSize());
        this.fadingSolutionTabuSize = ConfigUtils.inheritOverwritableProperty(this.fadingSolutionTabuSize, inheritedConfig.getFadingSolutionTabuSize());
        this.simulatedAnnealingStartingTemperature = ConfigUtils.inheritOverwritableProperty(this.simulatedAnnealingStartingTemperature, inheritedConfig.getSimulatedAnnealingStartingTemperature());
        this.greatDelugeWaterLevelUpperBoundRate = ConfigUtils.inheritOverwritableProperty(this.greatDelugeWaterLevelUpperBoundRate, inheritedConfig.getGreatDelugeWaterLevelUpperBoundRate());
        this.greatDelugeWaterRisingRate = ConfigUtils.inheritOverwritableProperty(this.greatDelugeWaterRisingRate, inheritedConfig.getGreatDelugeWaterRisingRate());
        this.lateAcceptanceSize = ConfigUtils.inheritOverwritableProperty(this.lateAcceptanceSize, inheritedConfig.getLateAcceptanceSize());
        this.lateSimulatedAnnealingSize = ConfigUtils.inheritOverwritableProperty(this.lateSimulatedAnnealingSize, inheritedConfig.getLateSimulatedAnnealingSize());
    }

    public static enum AcceptorType {
        HILL_CLIMBING,
        PLANNING_ENTITY_TABU,
        PLANNING_VALUE_TABU,
        MOVE_TABU,
        UNDO_MOVE_TABU,
        SOLUTION_TABU,
        SIMULATED_ANNEALING,
        GREAT_DELUGE,
        LATE_ACCEPTANCE,
        LATE_SIMULATED_ANNEALING;

    }
}

