/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.optaplanner.core.impl.domain.common.ReadMethodAccessor;

public final class DefaultReadMethodAccessor
implements ReadMethodAccessor {
    private final Method readMethod;
    private final Class<?> returnType;

    public DefaultReadMethodAccessor(Method readMethod) {
        this.readMethod = readMethod;
        readMethod.setAccessible(true);
        this.returnType = readMethod.getReturnType();
        if (this.returnType == Void.TYPE) {
            throw new IllegalArgumentException("The readMethod (" + readMethod + ") must not have the returnType (" + Void.TYPE + ")");
        }
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Object read(Object object) {
        try {
            return this.readMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call readMethod (" + this.readMethod.getName() + ") on an instance of class (" + object.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The readMethod (" + this.readMethod.getName() + ") on an instance of class (" + object.getClass() + ") throws an exception.", e.getCause());
        }
    }
}

