/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.cloner.PlanningCloneable;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.domain.value.ValueRangeProvider;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.optaplanner.core.impl.domain.solution.cloner.PlanningCloneableSolutionCloner;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListenerSupport;
import org.optaplanner.core.impl.solution.Solution;

public class SolutionDescriptor {
    private final Class<? extends Solution> solutionClass;
    private final BeanInfo solutionBeanInfo;
    private SolutionCloner solutionCloner;
    private final Map<String, PropertyAccessor> propertyAccessorMap;
    private final Map<String, PropertyAccessor> entityPropertyAccessorMap;
    private final Map<String, PropertyAccessor> entityCollectionPropertyAccessorMap;
    private final Map<Class<?>, PlanningEntityDescriptor> entityDescriptorMap;

    public SolutionDescriptor(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
        try {
            this.solutionBeanInfo = Introspector.getBeanInfo(solutionClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") is not a valid java bean.", e);
        }
        int mapSize = this.solutionBeanInfo.getPropertyDescriptors().length;
        this.propertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityPropertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityCollectionPropertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityDescriptorMap = new LinkedHashMap(mapSize);
    }

    public void addPlanningEntityDescriptor(PlanningEntityDescriptor entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getPlanningEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!otherEntityClass.isAssignableFrom(entityClass)) continue;
            throw new IllegalArgumentException("An earlier planningEntityClass (" + otherEntityClass + ") should not be a superclass of a later planningEntityClass (" + entityClass + "). Switch their declaration so superclasses are defined later.");
        }
        this.entityDescriptorMap.put(entityDescriptor.getPlanningEntityClass(), entityDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processSolutionAnnotations(descriptorPolicy);
        this.processMethodAnnotations(descriptorPolicy);
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has been specified as a solution in the configuration," + " but does not have a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        this.processSolutionCloner(descriptorPolicy, solutionAnnotation);
    }

    private void processSolutionCloner(DescriptorPolicy descriptorPolicy, PlanningSolution solutionAnnotation) {
        Class<? extends SolutionCloner> solutionClonerClass = solutionAnnotation.solutionCloner();
        if (solutionClonerClass == PlanningSolution.NullSolutionCloner.class) {
            solutionClonerClass = null;
        }
        this.solutionCloner = solutionClonerClass != null ? ConfigUtils.newInstance(this, "solutionClonerClass", solutionClonerClass) : (PlanningCloneable.class.isAssignableFrom(this.solutionClass) ? new PlanningCloneableSolutionCloner() : new FieldAccessingSolutionCloner(this));
    }

    private void processMethodAnnotations(DescriptorPolicy descriptorPolicy) {
        for (Method method : this.solutionClass.getMethods()) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            descriptorPolicy.addFromSolutionValueRangeProvider(method);
        }
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        boolean noPlanningEntityPropertyAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : this.solutionBeanInfo.getPropertyDescriptors()) {
            ReflectionPropertyAccessor propertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
            this.propertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
            Method propertyGetter = propertyAccessor.getReadMethod();
            if (propertyGetter == null) continue;
            if (propertyGetter.isAnnotationPresent(PlanningEntityProperty.class)) {
                noPlanningEntityPropertyAnnotation = false;
                this.entityPropertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
                continue;
            }
            if (!propertyGetter.isAnnotationPresent(PlanningEntityCollectionProperty.class)) continue;
            noPlanningEntityPropertyAnnotation = false;
            if (!Collection.class.isAssignableFrom(propertyAccessor.getPropertyType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a PlanningEntityCollection annotated property (" + propertyAccessor.getName() + ") that does not return a Collection.");
            }
            this.entityCollectionPropertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
        }
        if (noPlanningEntityPropertyAnnotation) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") should have at least 1 getter with a PlanningEntityCollection or PlanningEntityProperty" + " annotation.");
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (PlanningEntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        }
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public SolutionCloner getSolutionCloner() {
        return this.solutionCloner;
    }

    public Map<String, PropertyAccessor> getEntityPropertyAccessorMap() {
        return this.entityPropertyAccessorMap;
    }

    public Map<String, PropertyAccessor> getEntityCollectionPropertyAccessorMap() {
        return this.entityCollectionPropertyAccessorMap;
    }

    public PropertyAccessor getPropertyAccessor(String propertyName) {
        return this.propertyAccessorMap.get(propertyName);
    }

    public Set<Class<?>> getPlanningEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<PlanningEntityDescriptor> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<PlanningEntityDescriptor> getGenuineEntityDescriptors() {
        ArrayList<PlanningEntityDescriptor> genuineEntityDescriptorList = new ArrayList<PlanningEntityDescriptor>(this.entityDescriptorMap.size());
        for (PlanningEntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public boolean hasEntityDescriptorStrict(Class<?> planningEntityClass) {
        return this.entityDescriptorMap.containsKey(planningEntityClass);
    }

    public PlanningEntityDescriptor getEntityDescriptorStrict(Class<?> planningEntityClass) {
        return this.entityDescriptorMap.get(planningEntityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        for (Map.Entry<Class<?>, PlanningEntityDescriptor> entry : this.entityDescriptorMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entitySubclass)) continue;
            return true;
        }
        return false;
    }

    public PlanningEntityDescriptor getEntityDescriptor(Class<?> entitySubclass) {
        for (Map.Entry<Class<?>, PlanningEntityDescriptor> entry : this.entityDescriptorMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entitySubclass)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("A planning entity is an instance of a entitySubclass (" + entitySubclass + ") that is not configured as a planning entity.\n" + "If that class (" + entitySubclass.getSimpleName() + ") (or superclass thereof) is not a entityClass (" + this.getPlanningEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
    }

    public Collection<PlanningVariableDescriptor> getChainedVariableDescriptors() {
        ArrayList<PlanningVariableDescriptor> chainedVariableDescriptors = new ArrayList<PlanningVariableDescriptor>();
        for (PlanningEntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                chainedVariableDescriptors.add(variableDescriptor);
            }
        }
        return chainedVariableDescriptors;
    }

    public PlanningVariableListenerSupport buildVariableListenerSupport() {
        LinkedHashMap<PlanningVariableDescriptor, List<PlanningVariableListener>> variableListenerMap = new LinkedHashMap<PlanningVariableDescriptor, List<PlanningVariableListener>>();
        for (PlanningEntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.addVariableListenersToMap(variableListenerMap);
        }
        return new PlanningVariableListenerSupport(variableListenerMap);
    }

    public PlanningVariableDescriptor findVariableDescriptor(Object entity, String variableName) {
        PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
        return entityDescriptor.getVariableDescriptor(variableName);
    }

    public Collection<Object> getAllFacts(Solution solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        Collection<Object> problemFacts = solution.getProblemFacts();
        if (problemFacts == null) {
            throw new IllegalStateException("The solution (" + solution + ")'s method getProblemFacts() should never return null.");
        }
        facts.addAll(problemFacts);
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            facts.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                facts.add(entity);
            }
        }
        return facts;
    }

    public int getEntityCount(Solution solution) {
        int entityCount = 0;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            ++entityCount;
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            entityCount += entityCollection.size();
        }
        return entityCount;
    }

    public List<Object> getEntityList(Solution solution) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            entityList.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            entityList.addAll(entityCollection);
        }
        return entityList;
    }

    public List<Object> getEntityListByPlanningEntityClass(Solution solution, Class<?> planningEntityClass) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity;
            if (!entityPropertyAccessor.getPropertyType().isAssignableFrom(planningEntityClass) || (entity = this.extractPlanningEntity(entityPropertyAccessor, solution)) == null || !planningEntityClass.isInstance(entity)) continue;
            entityList.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                if (!planningEntityClass.isInstance(entity)) continue;
                entityList.add(entity);
            }
        }
        return entityList;
    }

    public int getValueCount(Solution solution) {
        boolean valueCount = false;
        throw new UnsupportedOperationException("getValueCount is not yet supported - this blocks ValueRatioTabuSizeStrategy");
    }

    public long getProblemScale(Solution solution) {
        long problemScale = 0L;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
            problemScale += entityDescriptor.getProblemScale(solution, entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
                problemScale += entityDescriptor.getProblemScale(solution, entity);
            }
        }
        return problemScale;
    }

    public int countUninitializedVariables(Solution solution) {
        int uninitializedVariableCount = 0;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
            uninitializedVariableCount += entityDescriptor.countUninitializedVariables(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
                uninitializedVariableCount += entityDescriptor.countUninitializedVariables(entity);
            }
        }
        return uninitializedVariableCount;
    }

    public boolean isInitialized(Solution solution) {
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            PlanningEntityDescriptor entityDescriptor;
            Object entity = this.extractPlanningEntity(entityPropertyAccessor, solution);
            if (entity == null || (entityDescriptor = this.getEntityDescriptor(entity.getClass())).isInitialized(entity)) continue;
            return false;
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor entityDescriptor = this.getEntityDescriptor(entity.getClass());
                if (entityDescriptor.isInitialized(entity)) continue;
                return false;
            }
        }
        return true;
    }

    private Object extractPlanningEntity(PropertyAccessor entityPropertyAccessor, Solution solution) {
        return entityPropertyAccessor.executeGetter(solution);
    }

    private Collection<?> extractPlanningEntityCollection(PropertyAccessor entityCollectionPropertyAccessor, Solution solution) {
        Collection entityCollection = (Collection)entityCollectionPropertyAccessor.executeGetter(solution);
        if (entityCollection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s entityCollectionProperty (" + entityCollectionPropertyAccessor.getName() + ") should never return null.");
        }
        return entityCollection;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

