/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public class XMLWriter
extends XMLWriterSupport {
    private Writer writer;

    public XMLWriter(Writer writer) {
        this(writer, "    ");
    }

    public XMLWriter(Writer writer, String indentString) {
        super(new SafeTagList(), 0, indentString);
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.writer = writer;
    }

    public void writeXmlDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.write(XMLWriter.getLineSeparator());
    }

    public void writeTag(String name, boolean close) throws IOException {
        if (close) {
            this.writeTag(this.writer, name, new AttributeList(), close);
        } else {
            this.writeTag(this.writer, name);
        }
    }

    public void writeCloseTag(String tag) throws IOException {
        this.writeCloseTag(this.writer, tag);
    }

    public void writeTag(String name, String attributeName, String attributeValue, boolean close) throws IOException {
        this.writeTag(this.writer, name, attributeName, attributeValue, close);
    }

    public void writeTag(String name, AttributeList attributes, boolean close) throws IOException {
        this.writeTag(this.writer, name, attributes, close);
    }

    public void writeTag(String name, Properties attributes, boolean close) throws IOException {
        this.writeTag(this.writer, name, attributes, close);
    }

    public void writeText(String text) throws IOException {
        this.writer.write(text);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

