/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestsolutionmutation;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.impl.statistic.AbstractSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationSingleStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.solution.mutation.MutationCounter;
import org.optaplanner.core.impl.event.BestSolutionChangedEvent;
import org.optaplanner.core.impl.event.SolverEventListener;
import org.optaplanner.core.impl.solution.Solution;

public class BestSolutionMutationSingleStatistic
extends AbstractSingleStatistic {
    private BestSolutionMutationSingleStatisticListener listener = new BestSolutionMutationSingleStatisticListener();
    private List<BestSolutionMutationSingleStatisticPoint> pointList = new ArrayList<BestSolutionMutationSingleStatisticPoint>();

    public List<BestSolutionMutationSingleStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void open(Solver solver) {
        SolutionDescriptor solutionDescriptor = solver.getScoreDirectorFactory().getSolutionDescriptor();
        this.listener.setMutationCounter(new MutationCounter(solutionDescriptor));
        solver.addEventListener((SolverEventListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        solver.removeEventListener((SolverEventListener)this.listener);
    }

    private class BestSolutionMutationSingleStatisticListener
    implements SolverEventListener {
        private MutationCounter mutationCounter;
        private Solution oldBestSolution = null;

        private BestSolutionMutationSingleStatisticListener() {
        }

        private void setMutationCounter(MutationCounter mutationCounter) {
            if (this.mutationCounter != null) {
                throw new IllegalStateException("Impossible that mutationCounter (" + mutationCounter + ") is not null.");
            }
            this.mutationCounter = mutationCounter;
        }

        public void bestSolutionChanged(BestSolutionChangedEvent event) {
            Solution newBestSolution = event.getNewBestSolution();
            int mutationCount = this.oldBestSolution == null ? 0 : this.mutationCounter.countMutations(this.oldBestSolution, newBestSolution);
            BestSolutionMutationSingleStatistic.this.pointList.add(new BestSolutionMutationSingleStatisticPoint(event.getTimeMillisSpend(), mutationCount));
            this.oldBestSolution = newBestSolution;
        }
    }
}

